/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.external.job.rest.service.api.acquire;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableForbiddenException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.rest.variable.EngineRestVariable;
import org.flowable.external.job.rest.service.api.ExternalJobRestResponseFactory;
import org.flowable.external.job.rest.service.api.ExternalWorkerJobBaseResource;
import org.flowable.external.job.rest.service.api.acquire.AcquireExternalWorkerJobRequest;
import org.flowable.external.job.rest.service.api.acquire.AcquiredExternalWorkerJobResponse;
import org.flowable.external.job.rest.service.api.acquire.ExternalWorkerJobCompleteRequest;
import org.flowable.external.job.rest.service.api.acquire.ExternalWorkerJobErrorRequest;
import org.flowable.external.job.rest.service.api.acquire.ExternalWorkerJobFailureRequest;
import org.flowable.external.job.rest.service.api.acquire.ExternalWorkerJobTerminateRequest;
import org.flowable.job.api.ExternalWorkerJob;
import org.flowable.job.api.ExternalWorkerJobAcquireBuilder;
import org.flowable.job.api.ExternalWorkerJobFailureBuilder;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Acquire and Execute"})
public class ExternalWorkerAcquireJobResource
extends ExternalWorkerJobBaseResource {
    protected final ExternalJobRestResponseFactory restResponseFactory;

    public ExternalWorkerAcquireJobResource(ExternalJobRestResponseFactory restResponseFactory) {
        this.restResponseFactory = restResponseFactory;
    }

    @ApiOperation(value="Acquire External Worker Jobs", tags={"Acquire and Execute"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the jobs were acquired and locked."), @ApiResponse(code=400, message="Indicates the request was invalid."), @ApiResponse(code=403, message="Indicates the user does not have the rights acquire the jobs.")})
    @PostMapping(value={"/acquire/jobs"}, produces={"application/json"})
    public List<AcquiredExternalWorkerJobResponse> acquireAndLockJobs(@RequestBody AcquireExternalWorkerJobRequest request) {
        ExternalWorkerJobAcquireBuilder acquireBuilder = this.createExternalWorkerAcquireBuilder();
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessAcquireExternalWorkerJobs(acquireBuilder, request);
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getTopic())) {
            if (request.getLockDuration() == null) {
                throw new FlowableIllegalArgumentException("lockDuration is required");
            }
        } else {
            throw new FlowableIllegalArgumentException("topic is required");
        }
        acquireBuilder.topic(request.getTopic(), request.getLockDuration());
        if (request.getScopeType() != null) {
            acquireBuilder.scopeType(request.getScopeType());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getWorkerId())) {
            List acquiredJobs = acquireBuilder.acquireAndLock(request.getNumberOfTasks(), request.getWorkerId(), request.getNumberOfRetries());
            return this.restResponseFactory.createAcquiredExternalWorkerJobResponseList(acquiredJobs);
        }
        throw new FlowableIllegalArgumentException("workerId is required");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiOperation(value="Complete an External Worker Jobs", code=204, tags={"Acquire and Execute"})
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the job was successfully completed."), @ApiResponse(code=400, message="Indicates the request was invalid."), @ApiResponse(code=403, message="Indicates the user does not have the rights complete the job."), @ApiResponse(code=404, message="Indicates the job does not exist.")})
    @PostMapping(value={"/acquire/jobs/{jobId}/complete"}, produces={"application/json"})
    public ResponseEntity<?> completeJob(@PathVariable String jobId, @RequestBody ExternalWorkerJobCompleteRequest request) {
        String workerId = request.getWorkerId();
        if (StringUtils.isEmpty((CharSequence)workerId)) {
            throw new FlowableIllegalArgumentException("workerId is required");
        }
        ExternalWorkerJob job = this.getExternalWorkerJobById(jobId);
        if (!workerId.equals(job.getLockOwner())) {
            throw new FlowableForbiddenException(workerId + " does not hold a lock on the requested job");
        }
        if (job.getProcessInstanceId() != null) {
            if (this.managementService == null) throw new FlowableException("Cannot complete BPMN job. There is no BPMN engine available");
            if (this.restApiInterceptor != null) {
                this.restApiInterceptor.completeExternalWorkerJob(job, request);
            }
            this.managementService.createExternalWorkerCompletionBuilder(job.getId(), workerId).variables(this.extractVariables(request.getVariables())).complete();
            return ResponseEntity.noContent().build();
        } else {
            if (!"cmmn".equals(job.getScopeType())) throw new FlowableIllegalArgumentException("Can only complete BPMN or CMMN external job. Job with id '" + jobId + "' is from scope '" + job.getScopeType() + "'");
            if (this.cmmnManagementService == null) throw new FlowableException("Cannot complete CMMN job. There is no CMMN engine available");
            if (this.restApiInterceptor != null) {
                this.restApiInterceptor.completeExternalWorkerJob(job, request);
            }
            this.cmmnManagementService.createCmmnExternalWorkerTransitionBuilder(job.getId(), workerId).variables(this.extractVariables(request.getVariables())).complete();
        }
        return ResponseEntity.noContent().build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiOperation(value="Complete an External Worker Job with a BPMN Error", code=204, tags={"Acquire and Execute"})
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the job was successfully completed."), @ApiResponse(code=400, message="Indicates the request was invalid."), @ApiResponse(code=403, message="Indicates the user does not have the rights complete the job."), @ApiResponse(code=404, message="Indicates the job does not exist.")})
    @PostMapping(value={"/acquire/jobs/{jobId}/bpmnError"}, produces={"application/json"})
    public ResponseEntity<?> bpmnErrorJob(@PathVariable String jobId, @RequestBody ExternalWorkerJobErrorRequest request) {
        String workerId = request.getWorkerId();
        if (StringUtils.isEmpty((CharSequence)workerId)) {
            throw new FlowableIllegalArgumentException("workerId is required");
        }
        ExternalWorkerJob job = this.getExternalWorkerJobById(jobId);
        if (!workerId.equals(job.getLockOwner())) {
            throw new FlowableForbiddenException(workerId + " does not hold a lock on the requested job");
        }
        if (job.getProcessInstanceId() == null) throw new FlowableIllegalArgumentException("Can only complete BPMN external job with a BPMN error. Job with id '" + jobId + "' is from scope '" + job.getScopeType() + "'");
        if (this.managementService == null) throw new FlowableException("Cannot complete BPMN job. There is no BPMN engine available");
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.bpmnErrorExternalWorkerJob(job, request);
        }
        this.managementService.createExternalWorkerCompletionBuilder(job.getId(), workerId).variables(this.extractVariables(request.getVariables())).bpmnError(request.getErrorCode());
        return ResponseEntity.noContent().build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiOperation(value="Complete an External Worker Job with a cmmn terminate transition", code=204, tags={"Acquire and Execute"})
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the job was successfully transitioned."), @ApiResponse(code=400, message="Indicates the request was invalid."), @ApiResponse(code=403, message="Indicates the user does not have the rights complete the job."), @ApiResponse(code=404, message="Indicates the job does not exist.")})
    @PostMapping(value={"/acquire/jobs/{jobId}/cmmnTerminate"}, produces={"application/json"})
    public ResponseEntity<?> terminateCmmnJob(@PathVariable String jobId, @RequestBody ExternalWorkerJobTerminateRequest request) {
        String workerId = request.getWorkerId();
        if (StringUtils.isEmpty((CharSequence)workerId)) {
            throw new FlowableIllegalArgumentException("workerId is required");
        }
        ExternalWorkerJob job = this.getExternalWorkerJobById(jobId);
        if (!workerId.equals(job.getLockOwner())) {
            throw new FlowableForbiddenException(workerId + " does not hold a lock on the requested job");
        }
        if (!"cmmn".equals(job.getScopeType())) throw new FlowableIllegalArgumentException("Can only terminate CMMN external job. Job with id '" + jobId + "' is from scope '" + job.getScopeType() + "'");
        if (this.cmmnManagementService == null) throw new FlowableException("Cannot complete CMMN job. There is no CMMN engine available");
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.cmmnTerminateExternalWorkerJob(job, request);
        }
        this.cmmnManagementService.createCmmnExternalWorkerTransitionBuilder(job.getId(), workerId).variables(this.extractVariables(request.getVariables())).terminate();
        return ResponseEntity.noContent().build();
    }

    @ApiOperation(value="Fail an External Worker Job", code=204, tags={"Acquire and Execute"})
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the job was successfully completed."), @ApiResponse(code=400, message="Indicates the request was invalid."), @ApiResponse(code=403, message="Indicates the user does not have the rights complete the job."), @ApiResponse(code=404, message="Indicates the job does not exist.")})
    @PostMapping(value={"/acquire/jobs/{jobId}/fail"}, produces={"application/json"})
    public ResponseEntity<?> failJob(@PathVariable String jobId, @RequestBody ExternalWorkerJobFailureRequest request) {
        String workerId = request.getWorkerId();
        if (StringUtils.isEmpty((CharSequence)workerId)) {
            throw new FlowableIllegalArgumentException("workerId is required");
        }
        ExternalWorkerJob job = this.getExternalWorkerJobById(jobId);
        if (!workerId.equals(job.getLockOwner())) {
            throw new FlowableForbiddenException(workerId + " does not hold a lock on the requested job");
        }
        ExternalWorkerJobFailureBuilder failureBuilder = this.createExternalWorkerJobFailureBuilder(jobId, workerId);
        if (request.getErrorMessage() != null) {
            failureBuilder.errorMessage(request.getErrorMessage());
        }
        if (request.getErrorDetails() != null) {
            failureBuilder.errorDetails(request.getErrorDetails());
        }
        if (request.getRetries() != null) {
            failureBuilder.retries(request.getRetries().intValue());
        }
        if (request.getRetryTimeout() != null) {
            failureBuilder.retryTimeout(request.getRetryTimeout());
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.failExternalWorkerJob(job, request);
        }
        failureBuilder.fail();
        return ResponseEntity.noContent().build();
    }

    protected Map<String, Object> extractVariables(List<EngineRestVariable> restVariables) {
        if (restVariables != null && !restVariables.isEmpty()) {
            HashMap<String, Object> variables = new HashMap<String, Object>();
            for (EngineRestVariable restVariable : restVariables) {
                if (restVariable.getName() == null) {
                    throw new FlowableIllegalArgumentException("Variable name is required.");
                }
                variables.put(restVariable.getName(), this.restResponseFactory.getVariableValue(restVariable));
            }
            return variables;
        }
        return Collections.emptyMap();
    }

    protected ExternalWorkerJobAcquireBuilder createExternalWorkerAcquireBuilder() {
        if (this.managementService != null) {
            return this.managementService.createExternalWorkerJobAcquireBuilder();
        }
        if (this.cmmnManagementService != null) {
            return this.cmmnManagementService.createExternalWorkerJobAcquireBuilder();
        }
        throw new FlowableException("Cannot acquire external jobs. There is no BPMN or CMMN engine available");
    }

    protected ExternalWorkerJobFailureBuilder createExternalWorkerJobFailureBuilder(String jobId, String workerId) {
        if (this.managementService != null) {
            return this.managementService.createExternalWorkerJobFailureBuilder(jobId, workerId);
        }
        if (this.cmmnManagementService != null) {
            return this.cmmnManagementService.createExternalWorkerJobFailureBuilder(jobId, workerId);
        }
        throw new FlowableException("Cannot fail external jobs. There is no BPMN or CMMN engine available");
    }
}

