/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.external.job.rest.service.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.rest.util.RestUrlBuilder;
import org.flowable.common.rest.variable.BooleanRestVariableConverter;
import org.flowable.common.rest.variable.DateRestVariableConverter;
import org.flowable.common.rest.variable.DoubleRestVariableConverter;
import org.flowable.common.rest.variable.EngineRestVariable;
import org.flowable.common.rest.variable.InstantRestVariableConverter;
import org.flowable.common.rest.variable.IntegerRestVariableConverter;
import org.flowable.common.rest.variable.JsonObjectRestVariableConverter;
import org.flowable.common.rest.variable.LocalDateRestVariableConverter;
import org.flowable.common.rest.variable.LocalDateTimeRestVariableConverter;
import org.flowable.common.rest.variable.LongRestVariableConverter;
import org.flowable.common.rest.variable.RestVariableConverter;
import org.flowable.common.rest.variable.ShortRestVariableConverter;
import org.flowable.common.rest.variable.StringRestVariableConverter;
import org.flowable.external.job.rest.service.api.ExternalJobRestUrls;
import org.flowable.external.job.rest.service.api.acquire.AcquiredExternalWorkerJobResponse;
import org.flowable.external.job.rest.service.api.query.ExternalWorkerJobResponse;
import org.flowable.job.api.AcquiredExternalWorkerJob;
import org.flowable.job.api.ExternalWorkerJob;

public class ExternalJobRestResponseFactory {
    protected ObjectMapper objectMapper;
    protected List<RestVariableConverter> variableConverters = new ArrayList<RestVariableConverter>();

    public ExternalJobRestResponseFactory(ObjectMapper objectMapper, Collection<RestVariableConverter> additionalRestVariableConverters) {
        this.objectMapper = objectMapper;
        this.initializeVariableConverters();
        this.variableConverters.addAll(additionalRestVariableConverters);
    }

    public List<AcquiredExternalWorkerJobResponse> createAcquiredExternalWorkerJobResponseList(List<AcquiredExternalWorkerJob> jobs) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<AcquiredExternalWorkerJobResponse> responseList = new ArrayList<AcquiredExternalWorkerJobResponse>(jobs.size());
        for (AcquiredExternalWorkerJob job : jobs) {
            responseList.add(this.createAcquiredExternalWorkerJobResponse(job, urlBuilder));
        }
        return responseList;
    }

    public List<ExternalWorkerJobResponse> createExternalWorkerJobResponseList(List<ExternalWorkerJob> jobs) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<ExternalWorkerJobResponse> responseList = new ArrayList<ExternalWorkerJobResponse>(jobs.size());
        for (ExternalWorkerJob instance : jobs) {
            responseList.add(this.createExternalWorkerJobResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public ExternalWorkerJobResponse createExternalWorkerJobResponse(ExternalWorkerJob job) {
        return this.createExternalWorkerJobResponse(job, this.createUrlBuilder());
    }

    protected ExternalWorkerJobResponse createExternalWorkerJobResponse(ExternalWorkerJob job, RestUrlBuilder urlBuilder) {
        return this.createExternalWorkerJobResponse(job, urlBuilder, ExternalWorkerJobResponse::new);
    }

    protected AcquiredExternalWorkerJobResponse createAcquiredExternalWorkerJobResponse(AcquiredExternalWorkerJob job, RestUrlBuilder urlBuilder) {
        AcquiredExternalWorkerJobResponse response = this.createExternalWorkerJobResponse((ExternalWorkerJob)job, urlBuilder, AcquiredExternalWorkerJobResponse::new);
        Map variables = job.getVariables();
        ArrayList<EngineRestVariable> restVariables = new ArrayList<EngineRestVariable>(variables.size());
        for (Map.Entry variable : variables.entrySet()) {
            restVariables.add(this.createRestVariable((String)variable.getKey(), variable.getValue()));
        }
        response.setVariables(restVariables);
        return response;
    }

    protected <T extends ExternalWorkerJobResponse> T createExternalWorkerJobResponse(ExternalWorkerJob job, RestUrlBuilder urlBuilder, Supplier<T> responseSupplier) {
        ExternalWorkerJobResponse response = (ExternalWorkerJobResponse)responseSupplier.get();
        response.setId(job.getId());
        response.setUrl(urlBuilder.buildUrl(ExternalJobRestUrls.URL_JOB, new Object[]{job.getId()}));
        response.setCorrelationId(job.getCorrelationId());
        response.setProcessInstanceId(job.getProcessInstanceId());
        response.setProcessDefinitionId(job.getProcessDefinitionId());
        response.setExecutionId(job.getExecutionId());
        response.setScopeId(job.getScopeId());
        response.setSubScopeId(job.getSubScopeId());
        response.setScopeDefinitionId(job.getScopeDefinitionId());
        response.setScopeType(job.getScopeType());
        response.setElementId(job.getElementId());
        response.setElementName(job.getElementName());
        response.setRetries(job.getRetries());
        response.setExceptionMessage(job.getExceptionMessage());
        response.setDueDate(job.getDuedate());
        response.setCreateTime(job.getCreateTime());
        response.setTenantId(job.getTenantId());
        response.setLockOwner(job.getLockOwner());
        response.setLockExpirationTime(job.getLockExpirationTime());
        return (T)response;
    }

    protected EngineRestVariable createRestVariable(String name, Object value) {
        EngineRestVariable restVariable = new EngineRestVariable();
        restVariable.setName(name);
        if (value != null) {
            RestVariableConverter converter = null;
            for (RestVariableConverter c : this.variableConverters) {
                if (!c.getVariableType().isAssignableFrom(value.getClass())) continue;
                converter = c;
                break;
            }
            if (converter != null) {
                converter.convertVariableValue(value, restVariable);
                restVariable.setType(converter.getRestTypeName());
            } else if (value instanceof Byte[] || value instanceof byte[]) {
                restVariable.setType("binary");
            } else {
                restVariable.setType("serializable");
            }
        }
        return restVariable;
    }

    public Object getVariableValue(EngineRestVariable restVariable) {
        Object value;
        if (restVariable.getType() != null) {
            RestVariableConverter converter = null;
            for (RestVariableConverter conv : this.variableConverters) {
                if (!conv.getRestTypeName().equals(restVariable.getType())) continue;
                converter = conv;
                break;
            }
            if (converter == null) {
                throw new FlowableIllegalArgumentException("Variable '" + restVariable.getName() + "' has unsupported type: '" + restVariable.getType() + "'.");
            }
            value = converter.getVariableValue(restVariable);
        } else {
            value = restVariable.getValue();
        }
        return value;
    }

    protected RestUrlBuilder createUrlBuilder() {
        return RestUrlBuilder.fromCurrentRequest();
    }

    protected void initializeVariableConverters() {
        this.variableConverters.add((RestVariableConverter)new StringRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new IntegerRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new LongRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new ShortRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new DoubleRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new BooleanRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new DateRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new InstantRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new LocalDateRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new LocalDateTimeRestVariableConverter());
        this.variableConverters.add((RestVariableConverter)new JsonObjectRestVariableConverter(this.objectMapper));
    }
}

