/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.external.job.rest.service.api.query;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.flowable.external.job.rest.service.api.ExternalJobRestResponseFactory;
import org.flowable.external.job.rest.service.api.ExternalWorkerJobBaseResource;
import org.flowable.external.job.rest.service.api.query.ExternalWorkerJobResponse;
import org.flowable.job.api.ExternalWorkerJob;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Info and Query"})
public class ExternalWorkerJobResource
extends ExternalWorkerJobBaseResource {
    protected final ExternalJobRestResponseFactory restResponseFactory;

    public ExternalWorkerJobResource(ExternalJobRestResponseFactory restResponseFactory) {
        this.restResponseFactory = restResponseFactory;
    }

    @ApiOperation(value="Get a single external worker job", tags={"Info and Query"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the requested job was returned."), @ApiResponse(code=403, message="Indicates the user does not have the rights access the job."), @ApiResponse(code=404, message="Indicates the requested job was not found.")})
    @GetMapping(value={"/jobs/{jobId}"}, produces={"application/json"})
    public ExternalWorkerJobResponse getExternalWorkerJob(@PathVariable String jobId) {
        ExternalWorkerJob job = this.getExternalWorkerJobById(jobId);
        return this.restResponseFactory.createExternalWorkerJobResponse(job);
    }
}

