/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.cmd;

import java.io.InputStream;
import java.io.Serializable;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.form.engine.impl.cmd.GetDeploymentResourceCmd;
import org.flowable.form.engine.impl.interceptor.Command;
import org.flowable.form.engine.impl.interceptor.CommandContext;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntity;

public class GetFormDefinitionResourceCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String formDefinitionId;

    public GetFormDefinitionResourceCmd(String formDefinitionId) {
        if (formDefinitionId == null || formDefinitionId.length() < 1) {
            throw new FlowableIllegalArgumentException("The form definition id is mandatory, but '" + formDefinitionId + "' has been provided.");
        }
        this.formDefinitionId = formDefinitionId;
    }

    @Override
    public InputStream execute(CommandContext commandContext) {
        FormDefinitionEntity formDefinition = commandContext.getFormEngineConfiguration().getDeploymentManager().findDeployedFormDefinitionById(this.formDefinitionId);
        String deploymentId = formDefinition.getDeploymentId();
        String resourceName = formDefinition.getResourceName();
        InputStream formDefinitionStream = new GetDeploymentResourceCmd(deploymentId, resourceName).execute(commandContext);
        return formDefinitionStream;
    }
}

