/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.deployer;

import org.flowable.editor.form.converter.FormJsonConverter;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.impl.context.Context;
import org.flowable.form.engine.impl.deployer.ParsedDeployment;
import org.flowable.form.engine.impl.persistence.deploy.DeploymentCache;
import org.flowable.form.engine.impl.persistence.deploy.FormDefinitionCacheEntry;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntity;
import org.flowable.form.engine.impl.persistence.entity.FormDeploymentEntity;
import org.flowable.form.model.FormModel;

public class CachingAndArtifactsManager {
    protected FormJsonConverter formJsonConverter = new FormJsonConverter();

    public void updateCachingAndArtifacts(ParsedDeployment parsedDeployment) {
        FormEngineConfiguration formEngineConfiguration = Context.getFormEngineConfiguration();
        DeploymentCache<FormDefinitionCacheEntry> formDefinitionCache = formEngineConfiguration.getDeploymentManager().getFormCache();
        FormDeploymentEntity deployment = parsedDeployment.getDeployment();
        for (FormDefinitionEntity formDefinition : parsedDeployment.getAllFormDefinitions()) {
            FormModel formModel = parsedDeployment.getFormModelForFormDefinition(formDefinition);
            formModel.setId(formDefinition.getId());
            FormDefinitionCacheEntry cacheEntry = new FormDefinitionCacheEntry(formDefinition, this.formJsonConverter.convertToJson(formModel));
            formDefinitionCache.add(formDefinition.getId(), cacheEntry);
            deployment.addDeployedArtifact(formDefinition);
        }
    }
}

