/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.engine.common.impl.persistence.entity.AbstractEntityNoRevision;
import org.flowable.form.engine.impl.persistence.entity.FormDeploymentEntity;
import org.flowable.form.engine.impl.persistence.entity.ResourceEntity;

public class FormDeploymentEntityImpl
extends AbstractEntityNoRevision
implements FormDeploymentEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String category;
    protected String tenantId = "";
    protected String parentDeploymentId;
    protected Map<String, ResourceEntity> resources;
    protected Date deploymentTime;
    protected boolean isNew;
    protected Map<Class<?>, List<Object>> deployedArtifacts;

    @Override
    public void addResource(ResourceEntity resource) {
        if (this.resources == null) {
            this.resources = new HashMap<String, ResourceEntity>();
        }
        this.resources.put(resource.getName(), resource);
    }

    @Override
    public Map<String, ResourceEntity> getResources() {
        return this.resources;
    }

    public Object getPersistentState() {
        HashMap<String, String> persistentState = new HashMap<String, String>();
        persistentState.put("category", this.category);
        persistentState.put("tenantId", this.tenantId);
        return persistentState;
    }

    @Override
    public void addDeployedArtifact(Object deployedArtifact) {
        Class<?> clazz;
        List<Object> artifacts;
        if (this.deployedArtifacts == null) {
            this.deployedArtifacts = new HashMap();
        }
        if ((artifacts = this.deployedArtifacts.get(clazz = deployedArtifact.getClass())) == null) {
            artifacts = new ArrayList<Object>();
            this.deployedArtifacts.put(clazz, artifacts);
        }
        artifacts.add(deployedArtifact);
    }

    @Override
    public <T> List<T> getDeployedArtifacts(Class<T> clazz) {
        for (Class<?> deployedArtifactsClass : this.deployedArtifacts.keySet()) {
            if (!clazz.isAssignableFrom(deployedArtifactsClass)) continue;
            return this.deployedArtifacts.get(deployedArtifactsClass);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getParentDeploymentId() {
        return this.parentDeploymentId;
    }

    @Override
    public void setParentDeploymentId(String parentDeploymentId) {
        this.parentDeploymentId = parentDeploymentId;
    }

    @Override
    public void setResources(Map<String, ResourceEntity> resources) {
        this.resources = resources;
    }

    public Date getDeploymentTime() {
        return this.deploymentTime;
    }

    @Override
    public void setDeploymentTime(Date deploymentTime) {
        this.deploymentTime = deploymentTime;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public String toString() {
        return "FormDeploymentEntity[id=" + this.id + ", name=" + this.name + "]";
    }
}

