/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.flowable.engine.common.impl.interceptor.CommandConfig;
import org.flowable.form.api.FormManagementService;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.api.FormService;
import org.flowable.form.engine.FormEngine;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.impl.db.DbSqlSession;
import org.flowable.form.engine.impl.interceptor.Command;
import org.flowable.form.engine.impl.interceptor.CommandContext;
import org.flowable.form.engine.impl.interceptor.CommandExecutor;
import org.flowable.form.engine.impl.test.AbstractTestCase;
import org.flowable.form.engine.test.FormTestHelper;
import org.junit.Assert;

public abstract class AbstractFlowableTestCase
extends AbstractTestCase {
    private static final List<String> TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK = new ArrayList<String>();
    protected FormEngine formEngine;
    protected String deploymentIdFromDeploymentAnnotation;
    protected List<String> deploymentIdsForAutoCleanup = new ArrayList<String>();
    protected Throwable exception;
    protected FormEngineConfiguration formEngineConfiguration;
    protected FormManagementService managementService;
    protected FormRepositoryService repositoryService;
    protected FormService formService;

    protected abstract void initializeFormEngine();

    protected void closeDownFormEngine() {
    }

    protected void nullifyServices() {
        this.formEngineConfiguration = null;
        this.managementService = null;
        this.repositoryService = null;
        this.formService = null;
    }

    public void runBare() throws Throwable {
        this.initializeFormEngine();
        if (this.repositoryService == null) {
            this.initializeServices();
        }
        try {
            this.deploymentIdFromDeploymentAnnotation = FormTestHelper.annotationDeploymentSetUp(this.formEngine, ((Object)((Object)this)).getClass(), this.getName());
            super.runBare();
        }
        catch (AssertionFailedError e) {
            log.error("\n");
            log.error("ASSERTION FAILED: {}", (Object)e, (Object)e);
            this.exception = e;
            throw e;
        }
        catch (Throwable e) {
            log.error("\n");
            log.error("EXCEPTION: {}", (Object)e, (Object)e);
            this.exception = e;
            throw e;
        }
        finally {
            if (this.deploymentIdFromDeploymentAnnotation != null) {
                FormTestHelper.annotationDeploymentTearDown(this.formEngine, this.deploymentIdFromDeploymentAnnotation, ((Object)((Object)this)).getClass(), this.getName());
                this.deploymentIdFromDeploymentAnnotation = null;
            }
            for (String autoDeletedDeploymentId : this.deploymentIdsForAutoCleanup) {
                this.repositoryService.deleteDeployment(autoDeletedDeploymentId);
            }
            this.deploymentIdsForAutoCleanup.clear();
            this.assertAndEnsureCleanDb();
            this.formEngineConfiguration.getClock().reset();
            this.closeDownFormEngine();
        }
    }

    protected void assertAndEnsureCleanDb() throws Throwable {
        log.debug("verifying that db is clean after test");
        Map tableCounts = this.managementService.getTableCount();
        StringBuilder outputMessage = new StringBuilder();
        for (String tableName : tableCounts.keySet()) {
            Long count;
            String tableNameWithoutPrefix = tableName.replace(this.formEngineConfiguration.getDatabaseTablePrefix(), "");
            if (TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.contains(tableNameWithoutPrefix) || (count = (Long)tableCounts.get(tableName)) == 0L) continue;
            outputMessage.append("  ").append(tableName).append(": ").append(count).append(" record(s) ");
        }
        if (outputMessage.length() > 0) {
            outputMessage.insert(0, "DB NOT CLEAN: \n");
            log.error("\n");
            log.error(outputMessage.toString());
            log.info("dropping and recreating db");
            CommandExecutor commandExecutor = this.formEngine.getFormEngineConfiguration().getCommandExecutor();
            CommandConfig config = new CommandConfig().transactionNotSupported();
            commandExecutor.execute(config, new Command<Object>(){

                @Override
                public Object execute(CommandContext commandContext) {
                    DbSqlSession session = commandContext.getDbSqlSession();
                    session.dbSchemaDrop();
                    session.dbSchemaCreate();
                    return null;
                }
            });
            if (this.exception != null) {
                throw this.exception;
            }
            Assert.fail((String)outputMessage.toString());
        } else {
            log.info("database was clean");
        }
    }

    protected void initializeServices() {
        this.formEngineConfiguration = this.formEngine.getFormEngineConfiguration();
        this.managementService = this.formEngine.getFormManagementService();
        this.repositoryService = this.formEngine.getFormRepositoryService();
        this.formService = this.formEngine.getFormService();
    }

    static {
        TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.add("ACT_FO_DATABASECHANGELOG");
        TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.add("ACT_FO_DATABASECHANGELOGLOCK");
    }
}

