/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl;

import java.io.InputStream;
import java.util.List;
import org.flowable.form.api.FormDefinition;
import org.flowable.form.api.FormDefinitionQuery;
import org.flowable.form.api.FormDeployment;
import org.flowable.form.api.FormDeploymentBuilder;
import org.flowable.form.api.FormDeploymentQuery;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.api.NativeFormDefinitionQuery;
import org.flowable.form.api.NativeFormDeploymentQuery;
import org.flowable.form.engine.impl.FormDefinitionQueryImpl;
import org.flowable.form.engine.impl.FormDeploymentQueryImpl;
import org.flowable.form.engine.impl.NativeFormDefinitionQueryImpl;
import org.flowable.form.engine.impl.NativeFormDeploymentQueryImpl;
import org.flowable.form.engine.impl.ServiceImpl;
import org.flowable.form.engine.impl.cmd.DeleteDeploymentCmd;
import org.flowable.form.engine.impl.cmd.DeployCmd;
import org.flowable.form.engine.impl.cmd.GetDeploymentResourceCmd;
import org.flowable.form.engine.impl.cmd.GetDeploymentResourceNamesCmd;
import org.flowable.form.engine.impl.cmd.GetFormDefinitionCmd;
import org.flowable.form.engine.impl.cmd.GetFormDefinitionResourceCmd;
import org.flowable.form.engine.impl.cmd.GetFormModelCmd;
import org.flowable.form.engine.impl.cmd.SetDeploymentCategoryCmd;
import org.flowable.form.engine.impl.cmd.SetDeploymentTenantIdCmd;
import org.flowable.form.engine.impl.cmd.SetFormDefinitionCategoryCmd;
import org.flowable.form.engine.impl.interceptor.Command;
import org.flowable.form.engine.impl.interceptor.CommandContext;
import org.flowable.form.engine.impl.repository.FormDeploymentBuilderImpl;
import org.flowable.form.model.FormModel;

public class FormRepositoryServiceImpl
extends ServiceImpl
implements FormRepositoryService {
    public FormDeploymentBuilder createDeployment() {
        return this.commandExecutor.execute(new Command<FormDeploymentBuilder>(){

            @Override
            public FormDeploymentBuilder execute(CommandContext commandContext) {
                return new FormDeploymentBuilderImpl();
            }
        });
    }

    public FormDeployment deploy(FormDeploymentBuilderImpl deploymentBuilder) {
        return this.commandExecutor.execute(new DeployCmd(deploymentBuilder));
    }

    public void deleteDeployment(String deploymentId) {
        this.commandExecutor.execute(new DeleteDeploymentCmd(deploymentId));
    }

    public FormDefinitionQuery createFormDefinitionQuery() {
        return new FormDefinitionQueryImpl(this.commandExecutor);
    }

    public NativeFormDefinitionQuery createNativeFormDefinitionQuery() {
        return new NativeFormDefinitionQueryImpl(this.commandExecutor);
    }

    public List<String> getDeploymentResourceNames(String deploymentId) {
        return this.commandExecutor.execute(new GetDeploymentResourceNamesCmd(deploymentId));
    }

    public InputStream getResourceAsStream(String deploymentId, String resourceName) {
        return this.commandExecutor.execute(new GetDeploymentResourceCmd(deploymentId, resourceName));
    }

    public void setDeploymentCategory(String deploymentId, String category) {
        this.commandExecutor.execute(new SetDeploymentCategoryCmd(deploymentId, category));
    }

    public void setDeploymentTenantId(String deploymentId, String newTenantId) {
        this.commandExecutor.execute(new SetDeploymentTenantIdCmd(deploymentId, newTenantId));
    }

    public FormDeploymentQuery createDeploymentQuery() {
        return new FormDeploymentQueryImpl(this.commandExecutor);
    }

    public NativeFormDeploymentQuery createNativeDeploymentQuery() {
        return new NativeFormDeploymentQueryImpl(this.commandExecutor);
    }

    public FormDefinition getFormDefinition(String formDefinitionId) {
        return this.commandExecutor.execute(new GetFormDefinitionCmd(formDefinitionId));
    }

    public FormModel getFormModelById(String formId) {
        return this.commandExecutor.execute(new GetFormModelCmd(null, formId));
    }

    public FormModel getFormModelByKey(String formDefinitionKey) {
        return this.commandExecutor.execute(new GetFormModelCmd(formDefinitionKey, null));
    }

    public FormModel getFormModelByKey(String formDefinitionKey, String tenantId) {
        return this.commandExecutor.execute(new GetFormModelCmd(formDefinitionKey, null, tenantId));
    }

    public FormModel getFormModelByKeyAndParentDeploymentId(String formDefinitionKey, String parentDeploymentId) {
        return this.commandExecutor.execute(new GetFormModelCmd(formDefinitionKey, null, null, parentDeploymentId));
    }

    public FormModel getFormModelByKeyAndParentDeploymentId(String formDefinitionKey, String parentDeploymentId, String tenantId) {
        return this.commandExecutor.execute(new GetFormModelCmd(formDefinitionKey, null, tenantId, parentDeploymentId));
    }

    public InputStream getFormDefinitionResource(String formId) {
        return this.commandExecutor.execute(new GetFormDefinitionResourceCmd(formId));
    }

    public void setFormDefinitionCategory(String formId, String category) {
        this.commandExecutor.execute(new SetFormDefinitionCategoryCmd(formId, category));
    }
}

