/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.cmd;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.form.api.FormInstance;
import org.flowable.form.engine.impl.interceptor.Command;
import org.flowable.form.engine.impl.interceptor.CommandContext;
import org.flowable.form.engine.impl.persistence.entity.FormInstanceEntity;
import org.flowable.form.engine.impl.persistence.entity.FormInstanceEntityManager;
import org.flowable.form.model.FormField;
import org.flowable.form.model.FormModel;
import org.joda.time.LocalDate;

public class CreateFormInstanceCmd
implements Command<FormInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected FormModel formModel;
    protected Map<String, Object> variables;
    protected String taskId;
    protected String processInstanceId;

    public CreateFormInstanceCmd(FormModel formModel, Map<String, Object> variables, String taskId, String processInstanceId) {
        this.formModel = formModel;
        this.variables = variables;
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
    }

    @Override
    public FormInstance execute(CommandContext commandContext) {
        if (this.formModel == null || this.formModel.getId() == null) {
            throw new FlowableException("Invalid form model provided");
        }
        ObjectMapper objectMapper = commandContext.getFormEngineConfiguration().getObjectMapper();
        ObjectNode submittedFormValuesJson = objectMapper.createObjectNode();
        ObjectNode valuesNode = submittedFormValuesJson.putObject("values");
        Map fieldMap = this.formModel.allFieldsAsMap();
        for (String fieldId : fieldMap.keySet()) {
            FormField formField = (FormField)fieldMap.get(fieldId);
            if ("expression".equals(formField.getType()) || "container".equals(formField.getType()) || !this.variables.containsKey(fieldId)) continue;
            Object variableValue = this.variables.get(fieldId);
            if (variableValue == null) {
                valuesNode.putNull(fieldId);
                continue;
            }
            if (variableValue instanceof Long) {
                valuesNode.put(fieldId, (Long)this.variables.get(fieldId));
                continue;
            }
            if (variableValue instanceof Double) {
                valuesNode.put(fieldId, (Double)this.variables.get(fieldId));
                continue;
            }
            if (variableValue instanceof LocalDate) {
                valuesNode.put(fieldId, ((LocalDate)variableValue).toString());
                continue;
            }
            valuesNode.put(fieldId, variableValue.toString());
        }
        String outcomeVariable = null;
        outcomeVariable = this.formModel.getOutcomeVariableName() != null ? this.formModel.getOutcomeVariableName() : "form_" + this.formModel.getKey() + "_outcome";
        if (this.variables.containsKey(outcomeVariable) && this.variables.get(outcomeVariable) != null) {
            submittedFormValuesJson.put("flowable_form_outcome", this.variables.get(outcomeVariable).toString());
        }
        FormInstanceEntityManager formInstanceEntityManager = commandContext.getFormInstanceEntityManager();
        FormInstanceEntity formInstanceEntity = (FormInstanceEntity)formInstanceEntityManager.create();
        formInstanceEntity.setFormDefinitionId(this.formModel.getId());
        formInstanceEntity.setTaskId(this.taskId);
        formInstanceEntity.setProcessInstanceId(this.processInstanceId);
        formInstanceEntity.setSubmittedDate(new Date());
        try {
            formInstanceEntity.setFormValueBytes(objectMapper.writeValueAsBytes((Object)submittedFormValuesJson));
        }
        catch (Exception e) {
            throw new FlowableException("Error setting form values JSON", (Throwable)e);
        }
        formInstanceEntityManager.insert(formInstanceEntity);
        return formInstanceEntity;
    }
}

