/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.cmd;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.editor.form.converter.FormJsonConverter;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.form.api.FormInstance;
import org.flowable.form.api.FormInstanceQuery;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.FormExpression;
import org.flowable.form.engine.impl.interceptor.Command;
import org.flowable.form.engine.impl.interceptor.CommandContext;
import org.flowable.form.engine.impl.persistence.deploy.DeploymentManager;
import org.flowable.form.engine.impl.persistence.deploy.FormDefinitionCacheEntry;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntity;
import org.flowable.form.model.ExpressionFormField;
import org.flowable.form.model.FormField;
import org.flowable.form.model.FormModel;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetFormModelWithVariablesCmd
implements Command<FormModel>,
Serializable {
    private static Logger logger = LoggerFactory.getLogger(GetFormModelWithVariablesCmd.class);
    private static final long serialVersionUID = 1L;
    protected String formDefinitionKey;
    protected String parentDeploymentId;
    protected String formDefinitionId;
    protected String processInstanceId;
    protected String tenantId;
    protected Map<String, Object> variables;

    public GetFormModelWithVariablesCmd(String formDefinitionKey, String formDefinitionId, String processInstanceId, Map<String, Object> variables) {
        this.initializeValues(formDefinitionKey, formDefinitionId, null, variables);
        this.processInstanceId = processInstanceId;
    }

    public GetFormModelWithVariablesCmd(String formDefinitionKey, String parentDeploymentId, String formDefinitionId, String processInstanceId, Map<String, Object> variables) {
        this.initializeValues(formDefinitionKey, formDefinitionId, null, variables);
        this.parentDeploymentId = parentDeploymentId;
        this.processInstanceId = processInstanceId;
    }

    public GetFormModelWithVariablesCmd(String formDefinitionKey, String parentDeploymentId, String formDefinitionId, String processInstanceId, String tenantId, Map<String, Object> variables) {
        this.initializeValues(formDefinitionKey, formDefinitionId, null, variables);
        this.parentDeploymentId = parentDeploymentId;
        this.processInstanceId = processInstanceId;
        this.tenantId = tenantId;
    }

    @Override
    public FormModel execute(CommandContext commandContext) {
        FormDefinitionCacheEntry formCacheEntry = this.resolveFormDefinition(commandContext);
        FormModel formModel = this.resolveFormModel(formCacheEntry, commandContext);
        this.fillFormFieldValues(formModel, commandContext);
        return formModel;
    }

    protected void initializeValues(String formDefinitionKey, String formDefinitionId, String tenantId, Map<String, Object> variables) {
        this.formDefinitionKey = formDefinitionKey;
        this.formDefinitionId = formDefinitionId;
        this.tenantId = tenantId;
        this.variables = variables != null ? variables : new HashMap<String, Object>();
    }

    protected void fillFormFieldValues(FormModel formDefinition, CommandContext commandContext) {
        FormEngineConfiguration formEngineConfiguration = commandContext.getFormEngineConfiguration();
        List allFields = formDefinition.listAllFields();
        if (allFields != null) {
            Map<String, JsonNode> formInstanceFieldMap = this.fillPreviousFormInstanceValues(formEngineConfiguration);
            this.fillVariablesWithFormInstanceValues(formInstanceFieldMap, allFields);
            for (FormField field : allFields) {
                if (field instanceof ExpressionFormField) {
                    ExpressionFormField expressionField = (ExpressionFormField)field;
                    FormExpression formExpression = formEngineConfiguration.getExpressionManager().createExpression(expressionField.getExpression());
                    try {
                        field.setValue(formExpression.getValue(this.variables));
                    }
                    catch (Exception e) {
                        logger.error("Error getting value for expression {} {}", new Object[]{expressionField.getExpression(), e.getMessage(), e});
                    }
                    continue;
                }
                field.setValue(this.variables.get(field.getId()));
            }
        }
    }

    protected FormDefinitionCacheEntry resolveFormDefinition(CommandContext commandContext) {
        DeploymentManager deploymentManager = commandContext.getFormEngineConfiguration().getDeploymentManager();
        FormDefinitionEntity formDefinitionEntity = null;
        if (this.formDefinitionId != null) {
            formDefinitionEntity = deploymentManager.findDeployedFormDefinitionById(this.formDefinitionId);
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for id = '" + this.formDefinitionId + "'", FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId)) && this.parentDeploymentId == null) {
            formDefinitionEntity = deploymentManager.findDeployedLatestFormDefinitionByKey(this.formDefinitionKey);
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for key '" + this.formDefinitionKey + "'", FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionKey != null && this.tenantId != null && !"".equals(this.tenantId) && this.parentDeploymentId == null) {
            formDefinitionEntity = deploymentManager.findDeployedLatestFormDefinitionByKeyAndTenantId(this.formDefinitionKey, this.tenantId);
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for key '" + this.formDefinitionKey + "' for tenant identifier " + this.tenantId, FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId)) && this.parentDeploymentId != null) {
            formDefinitionEntity = deploymentManager.findDeployedLatestFormDefinitionByKeyAndParentDeploymentId(this.formDefinitionKey, this.parentDeploymentId);
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for key '" + this.formDefinitionKey + "' for parent deployment id " + this.parentDeploymentId, FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionKey != null && this.tenantId != null && !"".equals(this.tenantId) && this.parentDeploymentId != null) {
            formDefinitionEntity = deploymentManager.findDeployedLatestFormDefinitionByKeyParentDeploymentIdAndTenantId(this.formDefinitionKey, this.parentDeploymentId, this.tenantId);
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for key '" + this.formDefinitionKey + "' for parent deployment id '" + this.parentDeploymentId + "' and for tenant identifier " + this.tenantId, FormDefinitionEntity.class);
            }
        } else {
            throw new FlowableObjectNotFoundException("formDefinitionKey and formDefinitionId are null");
        }
        FormDefinitionCacheEntry formCacheEntry = deploymentManager.resolveFormDefinition(formDefinitionEntity);
        return formCacheEntry;
    }

    protected Map<String, JsonNode> fillPreviousFormInstanceValues(FormEngineConfiguration formEngineConfiguration) {
        HashMap<String, JsonNode> formInstanceMap = new HashMap<String, JsonNode>();
        if (this.processInstanceId != null) {
            List formInstances = ((FormInstanceQuery)formEngineConfiguration.getFormService().createFormInstanceQuery().processInstanceId(this.processInstanceId).orderBySubmittedDate().desc()).list();
            for (FormInstance otherFormInstance : formInstances) {
                try {
                    JsonNode submittedNode = formEngineConfiguration.getObjectMapper().readTree(otherFormInstance.getFormValueBytes());
                    if (submittedNode == null || submittedNode.get("values") != null) continue;
                    JsonNode valuesNode = submittedNode.get("values");
                    Iterator fieldIdIterator = valuesNode.fieldNames();
                    while (fieldIdIterator.hasNext()) {
                        String fieldId = (String)fieldIdIterator.next();
                        if (formInstanceMap.containsKey(fieldId)) continue;
                        JsonNode valueNode = valuesNode.get(fieldId);
                        formInstanceMap.put(fieldId, valueNode);
                    }
                }
                catch (Exception e) {
                    throw new FlowableException("Error parsing form instance " + otherFormInstance.getId());
                }
            }
        }
        return formInstanceMap;
    }

    public void fillVariablesWithFormInstanceValues(Map<String, JsonNode> formInstanceFieldMap, List<FormField> allFields) {
        for (FormField field : allFields) {
            JsonNode fieldValueNode = formInstanceFieldMap.get(field.getId());
            if (fieldValueNode == null || fieldValueNode.isNull()) continue;
            String fieldType = field.getType();
            String fieldValue = fieldValueNode.asText();
            if ("date".equals(fieldType)) {
                try {
                    if (!StringUtils.isNotEmpty((CharSequence)fieldValue)) continue;
                    LocalDate dateValue = LocalDate.parse((String)fieldValue);
                    this.variables.put(field.getId(), dateValue);
                }
                catch (Exception e) {
                    logger.error("Error parsing form date value for process instance {} with value {}", new Object[]{this.processInstanceId, fieldValue, e});
                }
                continue;
            }
            this.variables.put(field.getId(), fieldValue);
        }
    }

    protected FormModel resolveFormModel(FormDefinitionCacheEntry formCacheEntry, CommandContext commandContext) {
        FormDefinitionEntity formEntity = formCacheEntry.getFormDefinitionEntity();
        FormJsonConverter formJsonConverter = commandContext.getFormEngineConfiguration().getFormJsonConverter();
        FormModel formDefinition = formJsonConverter.convertToFormModel(formCacheEntry.getFormDefinitionJson(), formEntity.getId(), formEntity.getVersion());
        formDefinition.setId(formEntity.getId());
        formDefinition.setName(formEntity.getName());
        formDefinition.setKey(formEntity.getKey());
        return formDefinition;
    }
}

