/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.flowable.form.engine.FlowableFormValidationException;
import org.flowable.form.engine.impl.interceptor.Command;
import org.flowable.form.engine.impl.interceptor.CommandContext;
import org.flowable.form.model.FormField;
import org.flowable.form.model.FormModel;
import org.joda.time.LocalDate;

public class GetVariablesFromFormSubmissionCmd
implements Command<Map<String, Object>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected FormModel formDefinition;
    protected Map<String, Object> values;
    protected String outcome;

    public GetVariablesFromFormSubmissionCmd(FormModel formDefinition, Map<String, Object> values) {
        this.formDefinition = formDefinition;
        this.values = values;
    }

    public GetVariablesFromFormSubmissionCmd(FormModel formDefinition, Map<String, Object> values, String outcome) {
        this(formDefinition, values);
        this.outcome = outcome;
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        if (this.values == null) {
            this.values = Collections.emptyMap();
        }
        Map fieldMap = this.formDefinition.allFieldsAsMap();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        for (String fieldId : fieldMap.keySet()) {
            Object variableValue = null;
            FormField formField = (FormField)fieldMap.get(fieldId);
            if ("expression".equals(formField.getType()) || "container".equals(formField.getType())) continue;
            if (this.values.containsKey(fieldId)) {
                variableValue = this.transformFormFieldValueToVariableValue(formField, this.values.get(fieldId));
                variables.put(formField.getId(), variableValue);
            }
            if (!formField.isRequired() || variableValue != null || "upload".equals(formField.getType())) continue;
            throw new FlowableFormValidationException("Form field " + formField.getId() + " is required, but no value was found");
        }
        if (this.outcome != null) {
            String targetVariable = null;
            targetVariable = this.formDefinition.getOutcomeVariableName() != null ? this.formDefinition.getOutcomeVariableName() : "form_" + this.formDefinition.getKey() + "_outcome";
            variables.put(targetVariable, this.outcome);
        }
        return variables;
    }

    protected Object transformFormFieldValueToVariableValue(FormField formField, Object formFieldValue) {
        Object result = formFieldValue;
        if (formField.getType().equals("date")) {
            if (StringUtils.isNotEmpty((CharSequence)((String)formFieldValue))) {
                try {
                    result = LocalDate.parse((String)((String)formFieldValue));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result = null;
                }
            }
        } else if (formField.getType().equals("integer") && formFieldValue instanceof String) {
            String strFieldValue = (String)formFieldValue;
            result = StringUtils.isNotEmpty((CharSequence)strFieldValue) && NumberUtils.isNumber((String)strFieldValue) ? Long.valueOf(strFieldValue) : null;
        } else if (formField.getType().equals("decimal") && formFieldValue instanceof String) {
            String strFieldValue = (String)formFieldValue;
            result = StringUtils.isNotEmpty((CharSequence)strFieldValue) && NumberUtils.isNumber((String)strFieldValue) ? Double.valueOf(strFieldValue) : null;
        } else if (formField.getType().equals("amount") && formFieldValue instanceof String) {
            try {
                result = Double.parseDouble((String)formFieldValue);
            }
            catch (NumberFormatException e) {
                result = null;
            }
        } else if (formField.getType().equals("dropdown")) {
            if (formFieldValue instanceof Map && (result = ((Map)formFieldValue).get("id")) == null) {
                result = ((Map)formFieldValue).get("name");
            }
        } else if (formField.getType().equals("upload")) {
            result = (String)formFieldValue;
        } else if (formField.getType().equals("people") || formField.getType().equals("functional-group")) {
            if (formFieldValue instanceof Map) {
                Map value = (Map)formFieldValue;
                result = value.get("id").toString();
            } else {
                result = null;
            }
        }
        return result;
    }
}

