/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.deployer;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.flowable.form.engine.impl.context.Context;
import org.flowable.form.engine.impl.deployer.ParsedDeployment;
import org.flowable.form.engine.impl.parser.FormDefinitionParse;
import org.flowable.form.engine.impl.parser.FormDefinitionParseFactory;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntity;
import org.flowable.form.engine.impl.persistence.entity.FormDeploymentEntity;
import org.flowable.form.engine.impl.persistence.entity.ResourceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsedDeploymentBuilder {
    private static final Logger log = LoggerFactory.getLogger(ParsedDeploymentBuilder.class);
    public static final String[] FORM_RESOURCE_SUFFIXES = new String[]{"form"};
    protected FormDeploymentEntity deployment;
    protected FormDefinitionParseFactory formDefinitionParseFactory;

    public ParsedDeploymentBuilder(FormDeploymentEntity deployment, FormDefinitionParseFactory formDefinitionParseFactory) {
        this.deployment = deployment;
        this.formDefinitionParseFactory = formDefinitionParseFactory;
    }

    public ParsedDeployment build() {
        ArrayList<FormDefinitionEntity> formDefinitions = new ArrayList<FormDefinitionEntity>();
        LinkedHashMap<FormDefinitionEntity, FormDefinitionParse> formDefinitionToParseMap = new LinkedHashMap<FormDefinitionEntity, FormDefinitionParse>();
        LinkedHashMap<FormDefinitionEntity, ResourceEntity> formDefinitionToResourceMap = new LinkedHashMap<FormDefinitionEntity, ResourceEntity>();
        for (ResourceEntity resource : this.deployment.getResources().values()) {
            if (!this.isFormResource(resource.getName())) continue;
            log.debug("Processing Form definition resource {}", (Object)resource.getName());
            FormDefinitionParse parse = this.createFormParseFromResource(resource);
            for (FormDefinitionEntity formDefinition : parse.getFormDefinitions()) {
                formDefinitions.add(formDefinition);
                formDefinitionToParseMap.put(formDefinition, parse);
                formDefinitionToResourceMap.put(formDefinition, resource);
            }
        }
        return new ParsedDeployment(this.deployment, formDefinitions, formDefinitionToParseMap, formDefinitionToResourceMap);
    }

    protected FormDefinitionParse createFormParseFromResource(ResourceEntity resource) {
        String resourceName = resource.getName();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(resource.getBytes());
        FormDefinitionParse formParse = this.formDefinitionParseFactory.createParse().sourceInputStream(inputStream).setSourceSystemId(resourceName).deployment(this.deployment).name(resourceName);
        formParse.execute(Context.getFormEngineConfiguration());
        return formParse;
    }

    protected boolean isFormResource(String resourceName) {
        for (String suffix : FORM_RESOURCE_SUFFIXES) {
            if (!resourceName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }
}

