/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.test;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.form.api.FormDeploymentBuilder;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.engine.FormEngine;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.impl.deployer.ParsedDeploymentBuilder;
import org.flowable.form.engine.test.FormDeploymentAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FormTestHelper {
    private static Logger log = LoggerFactory.getLogger(FormTestHelper.class);
    public static final String EMPTY_LINE = "\n";
    static Map<String, FormEngine> formEngines = new HashMap<String, FormEngine>();

    public static String annotationDeploymentSetUp(FormEngine formEngine, Class<?> testClass, String methodName) {
        String deploymentId = null;
        Method method = null;
        try {
            method = testClass.getMethod(methodName, null);
        }
        catch (Exception e) {
            log.warn("Could not get method by reflection. This could happen if you are using @Parameters in combination with annotations.", (Throwable)e);
            return null;
        }
        FormDeploymentAnnotation deploymentAnnotation = method.getAnnotation(FormDeploymentAnnotation.class);
        if (deploymentAnnotation != null) {
            log.debug("annotation @Deployment creates deployment for {}.{}", (Object)testClass.getSimpleName(), (Object)methodName);
            String[] resources = deploymentAnnotation.resources();
            if (resources.length == 0) {
                String name = method.getName();
                String resource = FormTestHelper.getFormResource(testClass, name);
                resources = new String[]{resource};
            }
            FormDeploymentBuilder deploymentBuilder = formEngine.getFormRepositoryService().createDeployment().name(testClass.getSimpleName() + "." + methodName);
            for (String resource : resources) {
                deploymentBuilder.addClasspathResource(resource);
            }
            deploymentId = deploymentBuilder.deploy().getId();
        }
        return deploymentId;
    }

    public static void annotationDeploymentTearDown(FormEngine formEngine, String deploymentId, Class<?> testClass, String methodName) {
        log.debug("annotation @Deployment deletes deployment for {}.{}", (Object)testClass.getSimpleName(), (Object)methodName);
        if (deploymentId != null) {
            try {
                formEngine.getFormRepositoryService().deleteDeployment(deploymentId);
            }
            catch (FlowableObjectNotFoundException flowableObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    public static String getFormResource(Class<?> type, String name) {
        for (String suffix : ParsedDeploymentBuilder.FORM_RESOURCE_SUFFIXES) {
            String resource = type.getName().replace('.', '/') + "." + name + "." + suffix;
            InputStream inputStream = FormTestHelper.class.getClassLoader().getResourceAsStream(resource);
            if (inputStream == null) continue;
            return resource;
        }
        return type.getName().replace('.', '/') + "." + name + "." + ParsedDeploymentBuilder.FORM_RESOURCE_SUFFIXES[0];
    }

    public static FormEngine getFormEngine(String configurationResource) {
        FormEngine formEngine = formEngines.get(configurationResource);
        if (formEngine == null) {
            log.debug("==== BUILDING FORM ENGINE ========================================================================");
            formEngine = FormEngineConfiguration.createFormEngineConfigurationFromResource(configurationResource).setDatabaseSchemaUpdate("drop-create").buildFormEngine();
            log.debug("==== FORM ENGINE CREATED =========================================================================");
            formEngines.put(configurationResource, formEngine);
        }
        return formEngine;
    }

    public static void closeFormEngines() {
        for (FormEngine formEngine : formEngines.values()) {
            formEngine.close();
        }
        formEngines.clear();
    }

    public static void assertAndEnsureCleanDb(FormEngine formEngine) {
        log.debug("verifying that db is clean after test");
        FormRepositoryService repositoryService = formEngine.getFormEngineConfiguration().getFormRepositoryService();
        List deployments = repositoryService.createDeploymentQuery().list();
        if (deployments != null && !deployments.isEmpty()) {
            throw new AssertionError((Object)"FormDeployments is not empty");
        }
    }
}

