/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.el;

import java.util.Map;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.javax.el.ELContext;
import org.flowable.engine.common.impl.javax.el.ELException;
import org.flowable.engine.common.impl.javax.el.MethodNotFoundException;
import org.flowable.engine.common.impl.javax.el.PropertyNotFoundException;
import org.flowable.engine.common.impl.javax.el.ValueExpression;
import org.flowable.form.engine.FormExpression;
import org.flowable.form.engine.impl.el.ExpressionManager;
import org.flowable.form.engine.impl.el.FlowableFormElContext;

public class JuelExpression
implements FormExpression {
    private static final long serialVersionUID = 1L;
    protected String expressionText;
    protected ValueExpression valueExpression;
    protected ExpressionManager expressionManager;

    public JuelExpression(ValueExpression valueExpression, String expressionText, ExpressionManager expressionManager) {
        this.valueExpression = valueExpression;
        this.expressionText = expressionText;
        this.expressionManager = expressionManager;
    }

    @Override
    public Object getValue(Map<String, Object> variables) {
        FlowableFormElContext elContext = this.expressionManager.createElContext(variables);
        try {
            return this.valueExpression.getValue((ELContext)elContext);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new FlowableException("Unknown property used in expression: " + this.expressionText, (Throwable)pnfe);
        }
        catch (MethodNotFoundException mnfe) {
            throw new FlowableException("Unknown method used in expression: " + this.expressionText, (Throwable)mnfe);
        }
        catch (ELException ele) {
            throw new FlowableException("Error while evaluating expression: " + this.expressionText, (Throwable)ele);
        }
        catch (Exception e) {
            throw new FlowableException("Error while evaluating expression: " + this.expressionText, (Throwable)e);
        }
    }

    @Override
    public void setValue(Object value, Map<String, Object> variables) {
    }

    public String toString() {
        if (this.valueExpression != null) {
            return this.valueExpression.getExpressionString();
        }
        return super.toString();
    }

    @Override
    public String getExpressionText() {
        return this.expressionText;
    }
}

