/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import org.flowable.engine.common.impl.persistence.entity.AbstractEntityNoRevision;
import org.flowable.form.engine.impl.persistence.entity.FormInstanceEntity;
import org.flowable.form.engine.impl.persistence.entity.ResourceRef;

public class FormInstanceEntityImpl
extends AbstractEntityNoRevision
implements FormInstanceEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String formDefinitionId;
    protected String taskId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected Date submittedDate;
    protected String submittedBy;
    protected String formValuesId;
    protected ResourceRef resourceRef;
    protected String tenantId = "";

    public Object getPersistentState() {
        HashMap<String, String> persistentState = new HashMap<String, String>();
        if (this.resourceRef != null && this.resourceRef.getId() != null) {
            persistentState.put("formValuesId", this.resourceRef.getId());
        }
        return persistentState;
    }

    public String getFormDefinitionId() {
        return this.formDefinitionId;
    }

    @Override
    public void setFormDefinitionId(String formDefinitionId) {
        this.formDefinitionId = formDefinitionId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    @Override
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Override
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public Date getSubmittedDate() {
        return this.submittedDate;
    }

    @Override
    public void setSubmittedDate(Date submittedDate) {
        this.submittedDate = submittedDate;
    }

    public String getSubmittedBy() {
        return this.submittedBy;
    }

    @Override
    public void setSubmittedBy(String submittedBy) {
        this.submittedBy = submittedBy;
    }

    public String getFormValuesId() {
        return this.formValuesId;
    }

    @Override
    public void setFormValuesId(String formValuesId) {
        this.formValuesId = formValuesId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public byte[] getFormValueBytes() {
        this.ensureResourceRefInitialized();
        return this.resourceRef.getBytes();
    }

    @Override
    public void setFormValueBytes(byte[] bytes) {
        this.ensureResourceRefInitialized();
        this.resourceRef.setValue("form-" + this.formDefinitionId, bytes);
    }

    public ResourceRef getResourceRef() {
        return this.resourceRef;
    }

    protected void ensureResourceRefInitialized() {
        if (this.resourceRef == null) {
            this.resourceRef = new ResourceRef();
        }
    }

    public String toString() {
        return "SubmittedFormEntity[" + this.id + "]";
    }
}

