/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.db;

import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSession;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.db.DbSchemaManager;
import org.flowable.engine.common.impl.db.DbSqlSession;
import org.flowable.form.engine.impl.util.CommandContextUtil;

public class FormDbSchemaManager
implements DbSchemaManager {
    public void dbSchemaCreate() {
        Liquibase liquibase = FormDbSchemaManager.createLiquibaseInstance();
        try {
            liquibase.update("form");
        }
        catch (Exception e) {
            throw new FlowableException("Error creating form engine tables", (Throwable)e);
        }
    }

    public void dbSchemaDrop() {
        Liquibase liquibase = FormDbSchemaManager.createLiquibaseInstance();
        try {
            liquibase.dropAll();
        }
        catch (Exception e) {
            throw new FlowableException("Error dropping form engine tables", (Throwable)e);
        }
    }

    public String dbSchemaUpdate() {
        this.dbSchemaCreate();
        return null;
    }

    protected static Liquibase createLiquibaseInstance() {
        try {
            DbSqlSession dbSqlSession = CommandContextUtil.getDbSqlSession();
            SqlSession sqlSession = dbSqlSession.getSqlSession();
            JdbcConnection connection = new JdbcConnection(sqlSession.getConnection());
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
            database.setDatabaseChangeLogTableName("ACT_FO_" + database.getDatabaseChangeLogTableName());
            database.setDatabaseChangeLogLockTableName("ACT_FO_" + database.getDatabaseChangeLogLockTableName());
            if (StringUtils.isNotEmpty((CharSequence)sqlSession.getConnection().getSchema())) {
                database.setDefaultSchemaName(sqlSession.getConnection().getSchema());
                database.setLiquibaseSchemaName(sqlSession.getConnection().getSchema());
            }
            if (StringUtils.isNotEmpty((CharSequence)sqlSession.getConnection().getCatalog())) {
                database.setDefaultCatalogName(sqlSession.getConnection().getCatalog());
                database.setLiquibaseCatalogName(sqlSession.getConnection().getCatalog());
            }
            Liquibase liquibase = new Liquibase("org/flowable/form/db/liquibase/flowable-form-db-changelog.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            return liquibase;
        }
        catch (Exception e) {
            throw new FlowableException("Error creating liquibase instance", (Throwable)e);
        }
    }
}

