/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.el;

import java.util.Map;
import org.flowable.engine.common.impl.javax.el.ArrayELResolver;
import org.flowable.engine.common.impl.javax.el.BeanELResolver;
import org.flowable.engine.common.impl.javax.el.CompositeELResolver;
import org.flowable.engine.common.impl.javax.el.ELContext;
import org.flowable.engine.common.impl.javax.el.ELResolver;
import org.flowable.engine.common.impl.javax.el.ExpressionFactory;
import org.flowable.engine.common.impl.javax.el.ListELResolver;
import org.flowable.engine.common.impl.javax.el.MapELResolver;
import org.flowable.engine.common.impl.javax.el.ValueExpression;
import org.flowable.form.engine.FormExpression;
import org.flowable.form.engine.impl.el.ExpressionFactoryResolver;
import org.flowable.form.engine.impl.el.FlowableFormElContext;
import org.flowable.form.engine.impl.el.JsonNodeELResolver;
import org.flowable.form.engine.impl.el.JuelExpression;
import org.flowable.form.engine.impl.el.ParsingElContext;
import org.flowable.form.engine.impl.el.ReadOnlyMapELResolver;
import org.flowable.form.engine.impl.el.VariableElResolver;

public class ExpressionManager {
    protected ExpressionFactory expressionFactory;
    protected ELContext parsingElContext = new ParsingElContext();
    protected Map<Object, Object> beans;

    public ExpressionManager() {
        this(null);
    }

    public ExpressionManager(boolean initFactory) {
        this(null, false);
    }

    public ExpressionManager(Map<Object, Object> beans) {
        this(beans, true);
    }

    public ExpressionManager(Map<Object, Object> beans, boolean initFactory) {
        this.expressionFactory = ExpressionFactoryResolver.resolveExpressionFactory();
        this.beans = beans;
    }

    public FormExpression createExpression(String expression) {
        ValueExpression valueExpression = this.expressionFactory.createValueExpression(this.parsingElContext, expression.trim(), Object.class);
        return new JuelExpression(valueExpression, expression, this);
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    public FlowableFormElContext createElContext(Map<String, Object> variables) {
        ELResolver elResolver = this.createElResolver(variables);
        return new FlowableFormElContext(elResolver);
    }

    protected ELResolver createElResolver(Map<String, Object> variables) {
        CompositeELResolver elResolver = new CompositeELResolver();
        elResolver.add((ELResolver)new VariableElResolver(variables));
        if (this.beans != null) {
            elResolver.add((ELResolver)new ReadOnlyMapELResolver(this.beans));
        }
        elResolver.add((ELResolver)new ArrayELResolver());
        elResolver.add((ELResolver)new ListELResolver());
        elResolver.add((ELResolver)new MapELResolver());
        elResolver.add((ELResolver)new JsonNodeELResolver());
        elResolver.add((ELResolver)new BeanELResolver());
        return elResolver;
    }

    public Map<Object, Object> getBeans() {
        return this.beans;
    }

    public void setBeans(Map<Object, Object> beans) {
        this.beans = beans;
    }
}

