/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.cmd;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.form.api.FormInstance;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.impl.persistence.entity.FormInstanceEntity;
import org.flowable.form.engine.impl.persistence.entity.FormInstanceEntityManager;
import org.flowable.form.engine.impl.util.CommandContextUtil;
import org.flowable.form.model.FormField;
import org.flowable.form.model.FormModel;
import org.joda.time.LocalDate;

public abstract class AbstractSaveFormInstanceCmd
implements Command<FormInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String formModelId;
    protected FormModel formModel;
    protected Map<String, Object> variables;
    protected String taskId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String scopeId;
    protected String scopeType;
    protected String scopeDefinitionId;

    public AbstractSaveFormInstanceCmd(FormModel formModel, Map<String, Object> variables, String taskId, String processInstanceId, String processDefinitionId) {
        this.formModel = formModel;
        this.variables = variables;
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.processDefinitionId = processDefinitionId;
    }

    public AbstractSaveFormInstanceCmd(String formModelId, Map<String, Object> variables, String taskId, String processInstanceId, String processDefinitionId) {
        this.formModelId = formModelId;
        this.variables = variables;
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.processDefinitionId = processDefinitionId;
    }

    public AbstractSaveFormInstanceCmd(String formModelId, Map<String, Object> variables, String taskId, String scopeId, String scopeType, String scopeDefinitionId) {
        this.formModelId = formModelId;
        this.variables = variables;
        this.taskId = taskId;
        this.scopeId = scopeId;
        this.scopeType = scopeType;
        this.scopeDefinitionId = scopeDefinitionId;
    }

    public AbstractSaveFormInstanceCmd(FormModel formModel, Map<String, Object> variables, String taskId, String scopeId, String scopeType, String scopeDefinitionId) {
        this.formModel = formModel;
        this.variables = variables;
        this.taskId = taskId;
        this.scopeId = scopeId;
        this.scopeType = scopeType;
        this.scopeDefinitionId = scopeDefinitionId;
    }

    public FormInstance execute(CommandContext commandContext) {
        if (this.formModel == null) {
            if (this.formModelId == null) {
                throw new FlowableException("Invalid form model and no form model Id provided");
            }
            this.formModel = CommandContextUtil.getFormEngineConfiguration().getFormRepositoryService().getFormModelById(this.formModelId);
        }
        if (this.formModel == null || this.formModel.getId() == null) {
            throw new FlowableException("Invalid form model provided");
        }
        ObjectMapper objectMapper = CommandContextUtil.getFormEngineConfiguration().getObjectMapper();
        ObjectNode submittedFormValuesJson = objectMapper.createObjectNode();
        ObjectNode valuesNode = submittedFormValuesJson.putObject("values");
        Map fieldMap = this.formModel.allFieldsAsMap();
        for (String fieldId : fieldMap.keySet()) {
            FormField formField = (FormField)fieldMap.get(fieldId);
            if ("expression".equals(formField.getType()) || "container".equals(formField.getType()) || !this.variables.containsKey(fieldId)) continue;
            Object variableValue = this.variables.get(fieldId);
            if (variableValue == null) {
                valuesNode.putNull(fieldId);
                continue;
            }
            if (variableValue instanceof Long) {
                valuesNode.put(fieldId, (Long)this.variables.get(fieldId));
                continue;
            }
            if (variableValue instanceof Double) {
                valuesNode.put(fieldId, (Double)this.variables.get(fieldId));
                continue;
            }
            if (variableValue instanceof LocalDate) {
                valuesNode.put(fieldId, ((LocalDate)variableValue).toString());
                continue;
            }
            valuesNode.put(fieldId, variableValue.toString());
        }
        String outcomeVariable = null;
        outcomeVariable = this.formModel.getOutcomeVariableName() != null ? this.formModel.getOutcomeVariableName() : "form_" + this.formModel.getKey() + "_outcome";
        if (this.variables.containsKey(outcomeVariable) && this.variables.get(outcomeVariable) != null) {
            submittedFormValuesJson.put("flowable_form_outcome", this.variables.get(outcomeVariable).toString());
        }
        FormInstanceEntityManager formInstanceEntityManager = CommandContextUtil.getFormInstanceEntityManager(commandContext);
        FormInstanceEntity formInstanceEntity = this.findExistingFormInstance(CommandContextUtil.getFormEngineConfiguration());
        if (formInstanceEntity == null) {
            formInstanceEntity = (FormInstanceEntity)formInstanceEntityManager.create();
        }
        formInstanceEntity.setFormDefinitionId(this.formModel.getId());
        formInstanceEntity.setTaskId(this.taskId);
        if (this.processInstanceId != null) {
            formInstanceEntity.setProcessInstanceId(this.processInstanceId);
            formInstanceEntity.setProcessDefinitionId(this.processDefinitionId);
        } else {
            formInstanceEntity.setScopeId(this.scopeId);
            formInstanceEntity.setScopeType(this.scopeType);
            formInstanceEntity.setScopeDefinitionId(this.scopeDefinitionId);
        }
        formInstanceEntity.setSubmittedDate(new Date());
        try {
            formInstanceEntity.setFormValueBytes(objectMapper.writeValueAsBytes((Object)submittedFormValuesJson));
        }
        catch (Exception e) {
            throw new FlowableException("Error setting form values JSON", (Throwable)e);
        }
        if (formInstanceEntity.getId() == null) {
            formInstanceEntityManager.insert(formInstanceEntity);
        } else {
            formInstanceEntityManager.update(formInstanceEntity);
        }
        return formInstanceEntity;
    }

    protected abstract FormInstanceEntity findExistingFormInstance(FormEngineConfiguration var1);
}

