/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.util;

import org.flowable.engine.common.api.FlowableException;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.impl.persistence.deploy.DeploymentManager;
import org.flowable.form.engine.impl.persistence.deploy.FormDefinitionCacheEntry;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntity;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntityManager;
import org.flowable.form.engine.impl.util.CommandContextUtil;
import org.flowable.form.model.FormModel;

public class FormUtil {
    public static FormDefinitionEntity getFormDefinitionEntity(String formDefinitionId) {
        return FormUtil.getFormDefinitionEntity(formDefinitionId, false);
    }

    public static FormDefinitionEntity getFormDefinitionEntity(String formDefinitionId, boolean checkCacheOnly) {
        if (checkCacheOnly) {
            FormDefinitionCacheEntry cacheEntry = (FormDefinitionCacheEntry)CommandContextUtil.getFormEngineConfiguration().getFormDefinitionCache().get(formDefinitionId);
            if (cacheEntry != null) {
                return cacheEntry.getFormDefinitionEntity();
            }
            return null;
        }
        return CommandContextUtil.getFormEngineConfiguration().getDeploymentManager().findDeployedFormDefinitionById(formDefinitionId);
    }

    public static FormModel getFormDefinition(String formDefinitionId) {
        FormEngineConfiguration formEngineConfiguration = CommandContextUtil.getFormEngineConfiguration();
        DeploymentManager deploymentManager = formEngineConfiguration.getDeploymentManager();
        FormDefinitionEntity formDefinitionEntity = deploymentManager.findDeployedFormDefinitionById(formDefinitionId);
        FormDefinitionCacheEntry cacheEntry = deploymentManager.resolveFormDefinition(formDefinitionEntity);
        return formEngineConfiguration.getFormJsonConverter().convertToFormModel(cacheEntry.getFormDefinitionJson(), cacheEntry.getFormDefinitionEntity().getId(), cacheEntry.getFormDefinitionEntity().getVersion());
    }

    public static FormModel getFormDefinitionFromCache(String formId) {
        FormEngineConfiguration formEngineConfiguration = CommandContextUtil.getFormEngineConfiguration();
        FormDefinitionCacheEntry cacheEntry = (FormDefinitionCacheEntry)formEngineConfiguration.getFormDefinitionCache().get(formId);
        if (cacheEntry != null) {
            return formEngineConfiguration.getFormJsonConverter().convertToFormModel(cacheEntry.getFormDefinitionJson(), cacheEntry.getFormDefinitionEntity().getId(), cacheEntry.getFormDefinitionEntity().getVersion());
        }
        return null;
    }

    public static FormDefinitionEntity getFormDefinitionFromDatabase(String formDefinitionId) {
        FormDefinitionEntityManager formDefinitionEntityManager = CommandContextUtil.getFormEngineConfiguration().getFormDefinitionEntityManager();
        FormDefinitionEntity formDefinition = (FormDefinitionEntity)formDefinitionEntityManager.findById(formDefinitionId);
        if (formDefinition == null) {
            throw new FlowableException("No form definitionfound with id " + formDefinitionId);
        }
        return formDefinition;
    }
}

