/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl;

import org.flowable.form.api.FormManagementService;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.api.FormService;
import org.flowable.form.engine.FormEngine;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.FormEngines;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormEngineImpl
implements FormEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormEngineImpl.class);
    protected String name;
    protected FormManagementService managementService;
    protected FormRepositoryService repositoryService;
    protected FormService formService;
    protected FormEngineConfiguration engineConfiguration;

    public FormEngineImpl(FormEngineConfiguration engineConfiguration) {
        this.engineConfiguration = engineConfiguration;
        this.name = engineConfiguration.getEngineName();
        this.managementService = engineConfiguration.getFormManagementService();
        this.repositoryService = engineConfiguration.getFormRepositoryService();
        this.formService = engineConfiguration.getFormService();
        if (engineConfiguration.getSchemaManagementCmd() != null) {
            engineConfiguration.getCommandExecutor().execute(engineConfiguration.getSchemaCommandConfig(), engineConfiguration.getSchemaManagementCmd());
        }
        if (this.name == null) {
            LOGGER.info("default flowable FormEngine created");
        } else {
            LOGGER.info("FormEngine {} created", (Object)this.name);
        }
        FormEngines.registerFormEngine(this);
    }

    @Override
    public void close() {
        FormEngines.unregister(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FormManagementService getFormManagementService() {
        return this.managementService;
    }

    @Override
    public FormRepositoryService getFormRepositoryService() {
        return this.repositoryService;
    }

    @Override
    public FormService getFormService() {
        return this.formService;
    }

    @Override
    public FormEngineConfiguration getFormEngineConfiguration() {
        return this.engineConfiguration;
    }
}

