/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl;

import java.io.InputStream;
import java.util.List;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.service.CommonEngineServiceImpl;
import org.flowable.form.api.FormDefinition;
import org.flowable.form.api.FormDefinitionQuery;
import org.flowable.form.api.FormDeployment;
import org.flowable.form.api.FormDeploymentBuilder;
import org.flowable.form.api.FormDeploymentQuery;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.api.NativeFormDefinitionQuery;
import org.flowable.form.api.NativeFormDeploymentQuery;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.impl.FormDefinitionQueryImpl;
import org.flowable.form.engine.impl.FormDeploymentQueryImpl;
import org.flowable.form.engine.impl.NativeFormDefinitionQueryImpl;
import org.flowable.form.engine.impl.NativeFormDeploymentQueryImpl;
import org.flowable.form.engine.impl.cmd.DeleteDeploymentCmd;
import org.flowable.form.engine.impl.cmd.DeployCmd;
import org.flowable.form.engine.impl.cmd.GetDeploymentResourceCmd;
import org.flowable.form.engine.impl.cmd.GetDeploymentResourceNamesCmd;
import org.flowable.form.engine.impl.cmd.GetFormDefinitionCmd;
import org.flowable.form.engine.impl.cmd.GetFormDefinitionResourceCmd;
import org.flowable.form.engine.impl.cmd.GetFormModelCmd;
import org.flowable.form.engine.impl.cmd.SetDeploymentCategoryCmd;
import org.flowable.form.engine.impl.cmd.SetDeploymentParentDeploymentIdCmd;
import org.flowable.form.engine.impl.cmd.SetDeploymentTenantIdCmd;
import org.flowable.form.engine.impl.cmd.SetFormDefinitionCategoryCmd;
import org.flowable.form.engine.impl.repository.FormDeploymentBuilderImpl;

public class FormRepositoryServiceImpl
extends CommonEngineServiceImpl<FormEngineConfiguration>
implements FormRepositoryService {
    public FormRepositoryServiceImpl(FormEngineConfiguration engineConfiguration) {
        super((AbstractEngineConfiguration)engineConfiguration);
    }

    public FormDeploymentBuilder createDeployment() {
        return (FormDeploymentBuilder)this.commandExecutor.execute((Command)new Command<FormDeploymentBuilder>(){

            public FormDeploymentBuilder execute(CommandContext commandContext) {
                return new FormDeploymentBuilderImpl();
            }
        });
    }

    public FormDeployment deploy(FormDeploymentBuilderImpl deploymentBuilder) {
        return (FormDeployment)this.commandExecutor.execute(new DeployCmd(deploymentBuilder));
    }

    public void deleteDeployment(String deploymentId) {
        this.commandExecutor.execute((Command)new DeleteDeploymentCmd(deploymentId));
    }

    public FormDefinitionQuery createFormDefinitionQuery() {
        return new FormDefinitionQueryImpl(this.commandExecutor);
    }

    public NativeFormDefinitionQuery createNativeFormDefinitionQuery() {
        return new NativeFormDefinitionQueryImpl(this.commandExecutor);
    }

    public List<String> getDeploymentResourceNames(String deploymentId) {
        return (List)this.commandExecutor.execute((Command)new GetDeploymentResourceNamesCmd(deploymentId));
    }

    public InputStream getResourceAsStream(String deploymentId, String resourceName) {
        return (InputStream)this.commandExecutor.execute((Command)new GetDeploymentResourceCmd(deploymentId, resourceName));
    }

    public void setDeploymentCategory(String deploymentId, String category) {
        this.commandExecutor.execute((Command)new SetDeploymentCategoryCmd(deploymentId, category));
    }

    public void setDeploymentTenantId(String deploymentId, String newTenantId) {
        this.commandExecutor.execute((Command)new SetDeploymentTenantIdCmd(deploymentId, newTenantId));
    }

    public void changeDeploymentParentDeploymentId(String deploymentId, String newParentDeploymentId) {
        this.commandExecutor.execute((Command)new SetDeploymentParentDeploymentIdCmd(deploymentId, newParentDeploymentId));
    }

    public FormDeploymentQuery createDeploymentQuery() {
        return new FormDeploymentQueryImpl(this.commandExecutor);
    }

    public NativeFormDeploymentQuery createNativeDeploymentQuery() {
        return new NativeFormDeploymentQueryImpl(this.commandExecutor);
    }

    public FormDefinition getFormDefinition(String formDefinitionId) {
        return (FormDefinition)this.commandExecutor.execute((Command)new GetFormDefinitionCmd(formDefinitionId));
    }

    public FormInfo getFormModelById(String formId) {
        return (FormInfo)this.commandExecutor.execute((Command)new GetFormModelCmd(null, formId));
    }

    public FormInfo getFormModelByKey(String formDefinitionKey) {
        return (FormInfo)this.commandExecutor.execute((Command)new GetFormModelCmd(formDefinitionKey, null));
    }

    public FormInfo getFormModelByKey(String formDefinitionKey, String tenantId) {
        return (FormInfo)this.commandExecutor.execute((Command)new GetFormModelCmd(formDefinitionKey, null, tenantId));
    }

    public FormInfo getFormModelByKeyAndParentDeploymentId(String formDefinitionKey, String parentDeploymentId) {
        return (FormInfo)this.commandExecutor.execute((Command)new GetFormModelCmd(formDefinitionKey, null, null, parentDeploymentId));
    }

    public FormInfo getFormModelByKeyAndParentDeploymentId(String formDefinitionKey, String parentDeploymentId, String tenantId) {
        return (FormInfo)this.commandExecutor.execute((Command)new GetFormModelCmd(formDefinitionKey, null, tenantId, parentDeploymentId));
    }

    public InputStream getFormDefinitionResource(String formId) {
        return (InputStream)this.commandExecutor.execute((Command)new GetFormDefinitionResourceCmd(formId));
    }

    public void setFormDefinitionCategory(String formId, String category) {
        this.commandExecutor.execute((Command)new SetFormDefinitionCategoryCmd(formId, category));
    }
}

