/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.cmd;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.VariableContainerWrapper;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.editor.form.converter.FormJsonConverter;
import org.flowable.form.api.FormDeployment;
import org.flowable.form.api.FormInstance;
import org.flowable.form.api.FormInstanceInfo;
import org.flowable.form.api.FormInstanceQuery;
import org.flowable.form.api.FormModel;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.impl.FormDeploymentQueryImpl;
import org.flowable.form.engine.impl.persistence.deploy.DeploymentManager;
import org.flowable.form.engine.impl.persistence.deploy.FormDefinitionCacheEntry;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntity;
import org.flowable.form.engine.impl.persistence.entity.FormInstanceEntity;
import org.flowable.form.engine.impl.util.CommandContextUtil;
import org.flowable.form.model.ExpressionFormField;
import org.flowable.form.model.FormField;
import org.flowable.form.model.Option;
import org.flowable.form.model.OptionFormField;
import org.flowable.form.model.SimpleFormModel;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractGetFormInstanceModelCmd
implements Command<FormInstanceInfo>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGetFormInstanceModelCmd.class);
    private static final long serialVersionUID = 1L;
    protected static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("d-M-yyyy");
    protected String formInstanceId;
    protected String formDefinitionKey;
    protected String parentDeploymentId;
    protected String formDefinitionId;
    protected String taskId;
    protected String processInstanceId;
    protected String scopeId;
    protected String scopeType;
    protected String tenantId;
    protected Map<String, Object> variables;

    public FormInstanceInfo execute(CommandContext commandContext) {
        if (this.formInstanceId == null && this.taskId == null && this.processInstanceId == null && this.scopeId == null) {
            throw new FlowableException("A processtask id or process instance id or scope id should be provided");
        }
        FormDefinitionCacheEntry formDefinitionCacheEntry = this.resolveFormDefinition(commandContext);
        FormInstance formInstance = this.resolveFormInstance(commandContext);
        FormInstanceInfo formInstanceModel = this.resolveFormInstanceModel(formDefinitionCacheEntry, formInstance, commandContext);
        this.fillFormFieldValues(formInstance, formInstanceModel, commandContext);
        return formInstanceModel;
    }

    protected void initializeValues(String formDefinitionKey, String parentDeploymentId, String formDefinitionId, String tenantId, String taskId, String processInstanceId, Map<String, Object> variables) {
        this.formDefinitionKey = formDefinitionKey;
        this.parentDeploymentId = parentDeploymentId;
        this.formDefinitionId = formDefinitionId;
        this.tenantId = tenantId;
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.variables = variables != null ? variables : new HashMap<String, Object>();
    }

    protected void initializeValuesForScope(String formDefinitionKey, String parentDeploymentId, String formDefinitionId, String tenantId, String scopeId, String scopeType, Map<String, Object> variables) {
        this.formDefinitionKey = formDefinitionKey;
        this.parentDeploymentId = parentDeploymentId;
        this.formDefinitionId = formDefinitionId;
        this.tenantId = tenantId;
        this.scopeId = scopeId;
        this.scopeType = scopeType;
        this.variables = variables != null ? variables : new HashMap<String, Object>();
    }

    protected void fillFormFieldValues(FormInstance formInstance, FormInstanceInfo formInstanceModel, CommandContext commandContext) {
        FormEngineConfiguration formEngineConfiguration = CommandContextUtil.getFormEngineConfiguration();
        SimpleFormModel formModel = (SimpleFormModel)formInstanceModel.getFormModel();
        List allFields = formModel.listAllFields();
        if (allFields != null) {
            HashMap<String, JsonNode> formInstanceFieldMap = new HashMap<String, JsonNode>();
            if (formInstance != null) {
                this.fillFormInstanceValues(formInstanceModel, formInstance, formInstanceFieldMap, formEngineConfiguration.getObjectMapper());
                this.fillVariablesWithFormValues(formInstanceFieldMap, allFields);
            }
            for (FormField field : allFields) {
                Object variableValue;
                if (field instanceof OptionFormField) {
                    OptionFormField optionFormField = (OptionFormField)field;
                    if (optionFormField.getOptionsExpression() != null) {
                        Expression optionsExpression = formEngineConfiguration.getExpressionManager().createExpression(optionFormField.getOptionsExpression());
                        Object value = null;
                        try {
                            value = optionsExpression.getValue((VariableContainer)new VariableContainerWrapper(this.variables));
                        }
                        catch (Exception e) {
                            throw new FlowableException("Error getting value for optionsExpression: " + optionFormField.getOptionsExpression(), (Throwable)e);
                        }
                        if (value instanceof List) {
                            List options = (List)value;
                            optionFormField.setOptions(options);
                        } else if (value instanceof String) {
                            String json = (String)value;
                            try {
                                List options = (List)formEngineConfiguration.getObjectMapper().readValue(json, (TypeReference)new TypeReference<List<Option>>(){});
                                optionFormField.setOptions(options);
                            }
                            catch (Exception e) {
                                throw new FlowableException("Error parsing optionsExpression json value: " + json, (Throwable)e);
                            }
                        } else {
                            throw new FlowableException("Invalid type from evaluated expression for optionsExpression: " + optionFormField.getOptionsExpression() + ", resulting type:" + value.getClass().getName());
                        }
                    }
                    Object variableValue2 = this.variables.get(field.getId());
                    optionFormField.setValue(variableValue2);
                } else if ("hyperlink".equals(field.getType())) {
                    variableValue = this.variables.get(field.getId());
                    if (variableValue != null) {
                        field.setValue(variableValue);
                    } else if (field.getParam("hyperlinkUrl") != null) {
                        String hyperlinkUrl = field.getParam("hyperlinkUrl").toString();
                        Expression formExpression = formEngineConfiguration.getExpressionManager().createExpression(hyperlinkUrl);
                        try {
                            field.setValue(formExpression.getValue((VariableContainer)new VariableContainerWrapper(this.variables)));
                        }
                        catch (Exception e) {
                            LOGGER.error("Error getting value for hyperlink expression {} {}", new Object[]{hyperlinkUrl, e.getMessage(), e});
                        }
                    }
                } else if (field instanceof ExpressionFormField) {
                    ExpressionFormField expressionField = (ExpressionFormField)field;
                    Expression formExpression = formEngineConfiguration.getExpressionManager().createExpression(expressionField.getExpression());
                    try {
                        field.setValue(formExpression.getValue((VariableContainer)new VariableContainerWrapper(this.variables)));
                    }
                    catch (Exception e) {
                        LOGGER.error("Error getting value for expression {} {}", (Object)expressionField.getExpression(), (Object)e.getMessage());
                    }
                } else if ("upload".equals(field.getType())) {
                    String uploadValue;
                    if (this.variables.containsKey(field.getId()) && (uploadValue = (String)this.variables.get(field.getId())) != null) {
                        ArrayList contentIds = new ArrayList();
                        Collections.addAll(contentIds, uploadValue.split(","));
                        field.setValue(contentIds);
                    }
                } else {
                    variableValue = this.variables.get(field.getId());
                    if (variableValue != null) {
                        if (variableValue instanceof LocalDate) {
                            field.setValue((Object)((LocalDate)variableValue).toString("d-M-yyyy"));
                        } else if (variableValue instanceof Date) {
                            field.setValue((Object)DATE_FORMAT.format((Date)variableValue));
                        } else {
                            field.setValue(variableValue);
                        }
                    }
                }
                field.setReadOnly(true);
            }
        }
    }

    protected FormDefinitionCacheEntry resolveFormDefinition(CommandContext commandContext) {
        List<FormDeployment> formDeployments;
        DeploymentManager deploymentManager = CommandContextUtil.getFormEngineConfiguration().getDeploymentManager();
        FormDefinitionEntity formDefinitionEntity = null;
        if (this.formInstanceId != null) {
            FormInstanceEntity formInstanceEntity = (FormInstanceEntity)CommandContextUtil.getFormEngineConfiguration().getFormInstanceDataManager().findById(this.formInstanceId);
            if (formInstanceEntity == null) {
                throw new FlowableObjectNotFoundException("No form instance found for id = '" + this.formInstanceId + "'", FormInstanceEntity.class);
            }
            formDefinitionEntity = deploymentManager.findDeployedFormDefinitionById(formInstanceEntity.getFormDefinitionId());
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for id = '" + this.formDefinitionId + "'", FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionId != null) {
            formDefinitionEntity = deploymentManager.findDeployedFormDefinitionById(this.formDefinitionId);
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for id = '" + this.formDefinitionId + "'", FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId)) && this.parentDeploymentId == null) {
            formDefinitionEntity = deploymentManager.findDeployedLatestFormDefinitionByKey(this.formDefinitionKey);
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for key '" + this.formDefinitionKey + "'", FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionKey != null && this.tenantId != null && !"".equals(this.tenantId) && this.parentDeploymentId == null) {
            formDefinitionEntity = deploymentManager.findDeployedLatestFormDefinitionByKeyAndTenantId(this.formDefinitionKey, this.tenantId);
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for key '" + this.formDefinitionKey + "' for tenant identifier " + this.tenantId, FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId)) && this.parentDeploymentId != null) {
            formDeployments = deploymentManager.getDeploymentEntityManager().findDeploymentsByQueryCriteria(new FormDeploymentQueryImpl().parentDeploymentId(this.parentDeploymentId));
            if (formDeployments != null && formDeployments.size() > 0) {
                formDefinitionEntity = deploymentManager.findDeployedLatestFormDefinitionByKeyAndDeploymentId(this.formDefinitionKey, formDeployments.get(0).getId());
            }
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for key '" + this.formDefinitionKey + "' for parent deployment id " + this.parentDeploymentId, FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionKey != null && this.tenantId != null && !"".equals(this.tenantId) && this.parentDeploymentId != null) {
            formDeployments = deploymentManager.getDeploymentEntityManager().findDeploymentsByQueryCriteria(new FormDeploymentQueryImpl().parentDeploymentId(this.parentDeploymentId).deploymentTenantId(this.tenantId));
            if (formDeployments != null && formDeployments.size() > 0) {
                formDefinitionEntity = deploymentManager.findDeployedLatestFormDefinitionByKeyDeploymentIdAndTenantId(this.formDefinitionKey, formDeployments.get(0).getId(), this.tenantId);
            }
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for key '" + this.formDefinitionKey + "' for parent deployment id '" + this.parentDeploymentId + "' and for tenant identifier " + this.tenantId, FormDefinitionEntity.class);
            }
        } else {
            throw new FlowableObjectNotFoundException("formDefinitionKey and formDefinitionId are null");
        }
        FormDefinitionCacheEntry formCacheEntry = deploymentManager.resolveFormDefinition(formDefinitionEntity);
        return formCacheEntry;
    }

    protected FormInstance resolveFormInstance(CommandContext commandContext) {
        FormEngineConfiguration formEngineConfiguration = CommandContextUtil.getFormEngineConfiguration();
        FormInstanceQuery formInstanceQuery = formEngineConfiguration.getFormService().createFormInstanceQuery().formDefinitionId(this.formDefinitionId);
        if (this.formInstanceId != null) {
            formInstanceQuery.id(this.formInstanceId);
        } else if (this.taskId != null) {
            formInstanceQuery.taskId(this.taskId);
        } else if (this.processInstanceId != null) {
            formInstanceQuery.processInstanceId(this.processInstanceId);
            if (this.taskId == null) {
                formInstanceQuery.withoutTaskId();
            }
        } else if (this.scopeId != null) {
            formInstanceQuery.scopeId(this.scopeId);
            formInstanceQuery.scopeType(this.scopeType);
            if (this.taskId == null) {
                formInstanceQuery.withoutTaskId();
            }
        } else {
            return null;
        }
        List formInstances = ((FormInstanceQuery)formInstanceQuery.orderBySubmittedDate().asc()).list();
        if (!formInstances.isEmpty()) {
            return (FormInstance)formInstances.get(0);
        }
        return null;
    }

    protected void fillFormInstanceValues(FormInstanceInfo formInstanceModel, FormInstance formInstance, Map<String, JsonNode> formInstanceFieldMap, ObjectMapper objectMapper) {
        try {
            JsonNode outcomeNode;
            JsonNode submittedNode = objectMapper.readTree(formInstance.getFormValueBytes());
            if (submittedNode == null) {
                return;
            }
            if (submittedNode.get("values") != null) {
                JsonNode valuesNode = submittedNode.get("values");
                Iterator fieldIdIterator = valuesNode.fieldNames();
                while (fieldIdIterator.hasNext()) {
                    String fieldId = (String)fieldIdIterator.next();
                    JsonNode valueNode = valuesNode.get(fieldId);
                    formInstanceFieldMap.put(fieldId, valueNode);
                }
            }
            if (submittedNode.get("flowable_form_outcome") != null && !(outcomeNode = submittedNode.get("flowable_form_outcome")).isNull() && StringUtils.isNotEmpty((CharSequence)outcomeNode.asText())) {
                formInstanceModel.setSelectedOutcome(outcomeNode.asText());
            }
        }
        catch (Exception e) {
            throw new FlowableException("Error parsing form instance " + formInstance.getId(), (Throwable)e);
        }
    }

    public void fillVariablesWithFormValues(Map<String, JsonNode> submittedFormFieldMap, List<FormField> allFields) {
        for (FormField field : allFields) {
            JsonNode fieldValueNode = submittedFormFieldMap.get(field.getId());
            if (fieldValueNode == null || fieldValueNode.isNull()) continue;
            String fieldType = field.getType();
            String fieldValue = fieldValueNode.asText();
            if ("date".equals(fieldType)) {
                try {
                    if (!StringUtils.isNotEmpty((CharSequence)fieldValue)) continue;
                    LocalDate dateValue = LocalDate.parse((String)fieldValue);
                    this.variables.put(field.getId(), dateValue.toString("d-M-yyyy"));
                }
                catch (Exception e) {
                    LOGGER.error("Error parsing form date value for process instance {} and task {} with value {}", new Object[]{this.processInstanceId, this.taskId, fieldValue, e});
                }
                continue;
            }
            if (fieldValueNode.isBoolean()) {
                this.variables.put(field.getId(), fieldValueNode.asBoolean());
                continue;
            }
            if (fieldValueNode.isLong()) {
                this.variables.put(field.getId(), fieldValueNode.asLong());
                continue;
            }
            if (fieldValueNode.isDouble()) {
                this.variables.put(field.getId(), fieldValueNode.asDouble());
                continue;
            }
            this.variables.put(field.getId(), fieldValue);
        }
    }

    protected FormInstanceInfo resolveFormInstanceModel(FormDefinitionCacheEntry formCacheEntry, FormInstance formInstance, CommandContext commandContext) {
        FormDefinitionEntity formDefinitionEntity = formCacheEntry.getFormDefinitionEntity();
        FormJsonConverter formJsonConverter = CommandContextUtil.getFormEngineConfiguration().getFormJsonConverter();
        SimpleFormModel formModel = formJsonConverter.convertToFormModel(formCacheEntry.getFormDefinitionJson());
        FormInstanceInfo formInstanceModel = new FormInstanceInfo();
        formInstanceModel.setId(formDefinitionEntity.getId());
        formInstanceModel.setName(formDefinitionEntity.getName());
        formInstanceModel.setVersion(formDefinitionEntity.getVersion());
        formInstanceModel.setKey(formDefinitionEntity.getKey());
        formInstanceModel.setTenantId(formDefinitionEntity.getTenantId());
        formInstanceModel.setFormModel((FormModel)formModel);
        if (formInstance != null) {
            formInstanceModel.setFormInstanceId(formInstance.getId());
            formInstanceModel.setTaskId(formInstance.getTaskId());
            formInstanceModel.setProcessInstanceId(formInstance.getProcessInstanceId());
            formInstanceModel.setProcessDefinitionId(formInstance.getProcessDefinitionId());
            formInstanceModel.setScopeId(formInstance.getScopeId());
            formInstanceModel.setScopeType(formInstance.getScopeType());
            formInstanceModel.setScopeDefinitionId(formInstance.getScopeDefinitionId());
            formInstanceModel.setSubmittedBy(formInstance.getSubmittedBy());
            formInstanceModel.setSubmittedDate(formInstance.getSubmittedDate());
        }
        return formInstanceModel;
    }
}

