/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.util;

import org.flowable.common.engine.api.FlowableException;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.impl.persistence.deploy.DeploymentManager;
import org.flowable.form.engine.impl.persistence.deploy.FormDefinitionCacheEntry;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntity;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntityManager;
import org.flowable.form.engine.impl.util.CommandContextUtil;
import org.flowable.form.model.SimpleFormModel;

public class FormUtil {
    public static FormDefinitionEntity getFormDefinitionEntity(String formDefinitionId) {
        return FormUtil.getFormDefinitionEntity(formDefinitionId, false);
    }

    public static FormDefinitionEntity getFormDefinitionEntity(String formDefinitionId, boolean checkCacheOnly) {
        if (checkCacheOnly) {
            FormDefinitionCacheEntry cacheEntry = (FormDefinitionCacheEntry)CommandContextUtil.getFormEngineConfiguration().getFormDefinitionCache().get(formDefinitionId);
            if (cacheEntry != null) {
                return cacheEntry.getFormDefinitionEntity();
            }
            return null;
        }
        return CommandContextUtil.getFormEngineConfiguration().getDeploymentManager().findDeployedFormDefinitionById(formDefinitionId);
    }

    public static SimpleFormModel getFormDefinition(String formDefinitionId) {
        FormEngineConfiguration formEngineConfiguration = CommandContextUtil.getFormEngineConfiguration();
        DeploymentManager deploymentManager = formEngineConfiguration.getDeploymentManager();
        FormDefinitionEntity formDefinitionEntity = deploymentManager.findDeployedFormDefinitionById(formDefinitionId);
        FormDefinitionCacheEntry cacheEntry = deploymentManager.resolveFormDefinition(formDefinitionEntity);
        return formEngineConfiguration.getFormJsonConverter().convertToFormModel(cacheEntry.getFormDefinitionJson());
    }

    public static SimpleFormModel getFormDefinitionFromCache(String formId) {
        FormEngineConfiguration formEngineConfiguration = CommandContextUtil.getFormEngineConfiguration();
        FormDefinitionCacheEntry cacheEntry = (FormDefinitionCacheEntry)formEngineConfiguration.getFormDefinitionCache().get(formId);
        if (cacheEntry != null) {
            return formEngineConfiguration.getFormJsonConverter().convertToFormModel(cacheEntry.getFormDefinitionJson());
        }
        return null;
    }

    public static FormDefinitionEntity getFormDefinitionFromDatabase(String formDefinitionId) {
        FormDefinitionEntityManager formDefinitionEntityManager = CommandContextUtil.getFormEngineConfiguration().getFormDefinitionEntityManager();
        FormDefinitionEntity formDefinition = (FormDefinitionEntity)formDefinitionEntityManager.findById(formDefinitionId);
        if (formDefinition == null) {
            throw new FlowableException("No form definitionfound with id " + formDefinitionId);
        }
        return formDefinition;
    }
}

