/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.db;

import java.sql.Connection;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.db.SchemaManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormDbSchemaManager
implements SchemaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormDbSchemaManager.class);
    public static String LIQUIBASE_CHANGELOG = "org/flowable/form/db/liquibase/flowable-form-db-changelog.xml";

    public void initSchema(FormEngineConfiguration formEngineConfiguration) {
        Liquibase liquibase = null;
        try {
            liquibase = FormDbSchemaManager.createLiquibaseInstance(formEngineConfiguration);
            String databaseSchemaUpdate = formEngineConfiguration.getDatabaseSchemaUpdate();
            if ("drop-create".equals(databaseSchemaUpdate)) {
                LOGGER.debug("Dropping and creating schema FORM");
                liquibase.dropAll();
                liquibase.update("form");
            } else if ("true".equals(databaseSchemaUpdate)) {
                LOGGER.debug("Updating schema FORM");
                liquibase.update("form");
            } else if ("false".equals(databaseSchemaUpdate)) {
                LOGGER.debug("Validating schema FORM");
                liquibase.validate();
            }
        }
        catch (Exception e) {
            throw new FlowableException("Error initialising form data schema", (Throwable)e);
        }
        finally {
            this.closeDatabase(liquibase);
        }
    }

    public void schemaCreate() {
        Liquibase liquibase = FormDbSchemaManager.createLiquibaseInstance();
        try {
            liquibase.update("form");
        }
        catch (Exception e) {
            throw new FlowableException("Error creating form engine tables", (Throwable)e);
        }
        finally {
            this.closeDatabase(liquibase);
        }
    }

    public void schemaDrop() {
        Liquibase liquibase = FormDbSchemaManager.createLiquibaseInstance();
        try {
            liquibase.dropAll();
        }
        catch (Exception e) {
            throw new FlowableException("Error dropping form engine tables", (Throwable)e);
        }
        finally {
            this.closeDatabase(liquibase);
        }
    }

    public String schemaUpdate() {
        this.schemaCreate();
        return null;
    }

    public void schemaCheckVersion() {
        Liquibase liquibase = null;
        try {
            liquibase = FormDbSchemaManager.createLiquibaseInstance(CommandContextUtil.getFormEngineConfiguration());
            liquibase.validate();
        }
        catch (Exception e) {
            throw new FlowableException("Error validating app engine schema", (Throwable)e);
        }
        finally {
            this.closeDatabase(liquibase);
        }
    }

    protected static Liquibase createLiquibaseInstance() {
        return FormDbSchemaManager.createLiquibaseInstance(CommandContextUtil.getFormEngineConfiguration());
    }

    protected static Liquibase createLiquibaseInstance(FormEngineConfiguration formEngineConfiguration) {
        try {
            Connection jdbcConnection = null;
            CommandContext commandContext = CommandContextUtil.getCommandContext();
            jdbcConnection = commandContext == null ? formEngineConfiguration.getDataSource().getConnection() : CommandContextUtil.getDbSqlSession(commandContext).getSqlSession().getConnection();
            if (!jdbcConnection.getAutoCommit()) {
                jdbcConnection.commit();
            }
            JdbcConnection connection = new JdbcConnection(jdbcConnection);
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
            database.setDatabaseChangeLogTableName("ACT_FO_" + database.getDatabaseChangeLogTableName());
            database.setDatabaseChangeLogLockTableName("ACT_FO_" + database.getDatabaseChangeLogLockTableName());
            if (StringUtils.isNotEmpty((CharSequence)formEngineConfiguration.getDatabaseSchema())) {
                database.setDefaultSchemaName(formEngineConfiguration.getDatabaseSchema());
                database.setLiquibaseSchemaName(formEngineConfiguration.getDatabaseSchema());
            }
            if (StringUtils.isNotEmpty((CharSequence)formEngineConfiguration.getDatabaseCatalog())) {
                database.setDefaultCatalogName(formEngineConfiguration.getDatabaseCatalog());
                database.setLiquibaseCatalogName(formEngineConfiguration.getDatabaseCatalog());
            }
            Liquibase liquibase = new Liquibase(LIQUIBASE_CHANGELOG, (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            return liquibase;
        }
        catch (Exception e) {
            throw new FlowableException("Error creating liquibase instance", (Throwable)e);
        }
    }

    private void closeDatabase(Liquibase liquibase) {
        Database database;
        if (liquibase != null && (database = liquibase.getDatabase()) != null && CommandContextUtil.getCommandContext() == null) {
            try {
                database.close();
            }
            catch (DatabaseException e) {
                LOGGER.warn("Error closing database", (Throwable)e);
            }
        }
    }
}

