/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.cmd;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormInstance;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.impl.persistence.entity.FormInstanceEntity;
import org.flowable.form.engine.impl.persistence.entity.FormInstanceEntityManager;
import org.flowable.form.engine.impl.util.CommandContextUtil;
import org.flowable.form.model.FormField;
import org.flowable.form.model.SimpleFormModel;
import org.joda.time.LocalDate;

public abstract class AbstractSaveFormInstanceCmd
implements Command<FormInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String formModelId;
    protected FormInfo formInfo;
    protected Map<String, Object> variables;
    protected String taskId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String scopeId;
    protected String scopeType;
    protected String scopeDefinitionId;
    protected String tenantId;
    protected String outcome;

    public AbstractSaveFormInstanceCmd(FormInfo formInfo, Map<String, Object> variables, String taskId, String processInstanceId, String processDefinitionId, String tenantId, String outcome) {
        this.formInfo = formInfo;
        this.variables = variables;
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.processDefinitionId = processDefinitionId;
        this.tenantId = tenantId;
        this.outcome = outcome;
    }

    public AbstractSaveFormInstanceCmd(String formModelId, Map<String, Object> variables, String taskId, String processInstanceId, String processDefinitionId, String tenantId, String outcome) {
        this.formModelId = formModelId;
        this.variables = variables;
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.processDefinitionId = processDefinitionId;
        this.tenantId = tenantId;
        this.outcome = outcome;
    }

    public AbstractSaveFormInstanceCmd(String formModelId, Map<String, Object> variables, String taskId, String scopeId, String scopeType, String scopeDefinitionId, String tenantId, String outcome) {
        this.formModelId = formModelId;
        this.variables = variables;
        this.taskId = taskId;
        this.scopeId = scopeId;
        this.scopeType = scopeType;
        this.scopeDefinitionId = scopeDefinitionId;
        this.tenantId = tenantId;
        this.outcome = outcome;
    }

    public AbstractSaveFormInstanceCmd(FormInfo formInfo, Map<String, Object> variables, String taskId, String scopeId, String scopeType, String scopeDefinitionId, String tenantId, String outcome) {
        this.formInfo = formInfo;
        this.variables = variables;
        this.taskId = taskId;
        this.scopeId = scopeId;
        this.scopeType = scopeType;
        this.scopeDefinitionId = scopeDefinitionId;
        this.tenantId = tenantId;
        this.outcome = outcome;
    }

    public FormInstance execute(CommandContext commandContext) {
        FormEngineConfiguration formEngineConfiguration = CommandContextUtil.getFormEngineConfiguration();
        if (this.formInfo == null) {
            if (this.formModelId == null) {
                throw new FlowableException("Invalid form model and no form model Id provided");
            }
            this.formInfo = CommandContextUtil.getFormEngineConfiguration().getFormRepositoryService().getFormModelById(this.formModelId);
        }
        if (this.formInfo == null || this.formInfo.getId() == null) {
            throw new FlowableException("Invalid form model provided");
        }
        ObjectMapper objectMapper = formEngineConfiguration.getObjectMapper();
        ObjectNode submittedFormValuesJson = objectMapper.createObjectNode();
        ObjectNode valuesNode = submittedFormValuesJson.putObject("values");
        SimpleFormModel formModel = (SimpleFormModel)this.formInfo.getFormModel();
        Map fieldMap = formModel.allFieldsAsMap();
        for (String fieldId : fieldMap.keySet()) {
            FormField formField = (FormField)fieldMap.get(fieldId);
            if ("expression".equals(formField.getType()) || "container".equals(formField.getType()) || this.variables == null || !this.variables.containsKey(fieldId)) continue;
            Object variableValue = this.variables.get(fieldId);
            if (variableValue == null) {
                valuesNode.putNull(fieldId);
                continue;
            }
            if (variableValue instanceof Long) {
                valuesNode.put(fieldId, (Long)this.variables.get(fieldId));
                continue;
            }
            if (variableValue instanceof Double) {
                valuesNode.put(fieldId, (Double)this.variables.get(fieldId));
                continue;
            }
            if (variableValue instanceof Boolean) {
                valuesNode.put(fieldId, (Boolean)this.variables.get(fieldId));
                continue;
            }
            if (variableValue instanceof LocalDate) {
                valuesNode.put(fieldId, ((LocalDate)variableValue).toString());
                continue;
            }
            valuesNode.put(fieldId, variableValue.toString());
        }
        if (this.outcome != null) {
            submittedFormValuesJson.put("flowable_form_outcome", this.outcome);
        }
        FormInstanceEntityManager formInstanceEntityManager = CommandContextUtil.getFormInstanceEntityManager(commandContext);
        FormInstanceEntity formInstanceEntity = this.findExistingFormInstance(formEngineConfiguration);
        if (formInstanceEntity == null) {
            formInstanceEntity = (FormInstanceEntity)formInstanceEntityManager.create();
        }
        formInstanceEntity.setFormDefinitionId(this.formInfo.getId());
        formInstanceEntity.setTaskId(this.taskId);
        if (this.processInstanceId != null) {
            formInstanceEntity.setProcessInstanceId(this.processInstanceId);
            formInstanceEntity.setProcessDefinitionId(this.processDefinitionId);
        } else {
            formInstanceEntity.setScopeId(this.scopeId);
            formInstanceEntity.setScopeType(this.scopeType);
            formInstanceEntity.setScopeDefinitionId(this.scopeDefinitionId);
        }
        formInstanceEntity.setSubmittedDate(formEngineConfiguration.getClock().getCurrentTime());
        formInstanceEntity.setSubmittedBy(Authentication.getAuthenticatedUserId());
        if (this.tenantId != null) {
            formInstanceEntity.setTenantId(this.tenantId);
        }
        try {
            formInstanceEntity.setFormValueBytes(objectMapper.writeValueAsBytes((Object)submittedFormValuesJson));
        }
        catch (Exception e) {
            throw new FlowableException("Error setting form values JSON", (Throwable)e);
        }
        if (formInstanceEntity.getId() == null) {
            formInstanceEntityManager.insert(formInstanceEntity);
        } else {
            formInstanceEntityManager.update(formInstanceEntity);
        }
        return formInstanceEntity;
    }

    protected abstract FormInstanceEntity findExistingFormInstance(FormEngineConfiguration var1);
}

