/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.form.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.flowable.editor.form.converter.FlowableFormJsonException;
import org.flowable.form.model.FormModel;

public class FormJsonConverter {
    protected ObjectMapper objectMapper = new ObjectMapper();

    public FormModel convertToFormModel(String modelJson, String modelId, int modelVersion) {
        try {
            FormModel definition = (FormModel)this.objectMapper.readValue(modelJson, FormModel.class);
            definition.setId(modelId);
            definition.setVersion(modelVersion);
            return definition;
        }
        catch (Exception e) {
            throw new FlowableFormJsonException("Error reading form json", e);
        }
    }

    public String convertToJson(FormModel definition) {
        try {
            return this.objectMapper.writeValueAsString((Object)definition);
        }
        catch (Exception e) {
            throw new FlowableFormJsonException("Error writing form json", e);
        }
    }
}

