/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.api.FormService;
import org.flowable.form.rest.FormRestApiInterceptor;
import org.flowable.form.rest.FormRestResponseFactory;
import org.flowable.form.rest.service.api.form.FormModelResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Form Definitions"}, description="Manage Form Definitions", authorizations={@Authorization(value="basicAuth")})
public class FormModelResource {
    @Autowired
    protected FormRestResponseFactory formRestResponseFactory;
    @Autowired
    protected FormService formService;
    @Autowired
    protected FormRepositoryService formRepositoryService;
    @Autowired(required=false)
    protected FormRestApiInterceptor restApiInterceptor;

    @ApiOperation(value="Get a form definition Form model", tags={"Form Definitions"}, nickname="getFormDefinitionFormModel")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the form definition Form model was found returned."), @ApiResponse(code=404, message="Indicates the form definition Form model was not found.")})
    @GetMapping(value={"/form-repository/form-definitions/{formDefinitionId}/model"}, produces={"application/json"})
    public FormModelResponse getModelResource(@ApiParam(name="formDefinitionId") @PathVariable String formDefinitionId) {
        FormInfo formInfo = this.formRepositoryService.getFormModelById(formDefinitionId);
        if (formInfo == null) {
            throw new FlowableObjectNotFoundException("Could not find a form model with id '" + formDefinitionId);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessFormInfoById(formInfo, null);
        }
        return this.formRestResponseFactory.createFormModelResponse(formInfo);
    }
}

