/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.spring;

import java.net.URL;
import java.util.Map;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.form.engine.FormEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class SpringFormConfigurationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringFormConfigurationHelper.class);

    public static FormEngine buildFormEngine(URL resource) {
        LOGGER.debug("==== BUILDING SPRING APPLICATION CONTEXT AND FORM ENGINE =========================================");
        try (GenericXmlApplicationContext applicationContext = new GenericXmlApplicationContext(new Resource[]{new UrlResource(resource)});){
            Map beansOfType = applicationContext.getBeansOfType(FormEngine.class);
            if (beansOfType == null || beansOfType.isEmpty()) {
                throw new FlowableException("no " + FormEngine.class.getName() + " defined in the application context " + resource.toString());
            }
            FormEngine formEngine = (FormEngine)beansOfType.values().iterator().next();
            LOGGER.debug("==== SPRING FORM ENGINE CREATED ==================================================================");
            FormEngine formEngine2 = formEngine;
            return formEngine2;
        }
    }
}

