/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.spring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.interceptor.CommandConfig;
import org.flowable.engine.common.impl.interceptor.CommandInterceptor;
import org.flowable.form.engine.FormEngine;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.FormEngines;
import org.flowable.form.engine.impl.cfg.StandaloneFormEngineConfiguration;
import org.flowable.form.spring.SpringTransactionContextFactory;
import org.flowable.form.spring.SpringTransactionInterceptor;
import org.flowable.form.spring.autodeployment.AutoDeploymentStrategy;
import org.flowable.form.spring.autodeployment.DefaultAutoDeploymentStrategy;
import org.flowable.form.spring.autodeployment.ResourceParentFolderAutoDeploymentStrategy;
import org.flowable.form.spring.autodeployment.SingleResourceAutoDeploymentStrategy;
import org.flowable.spring.common.SpringEngineConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;

public class SpringFormEngineConfiguration
extends FormEngineConfiguration
implements SpringEngineConfiguration {
    protected PlatformTransactionManager transactionManager;
    protected String deploymentName = "SpringAutoDeployment";
    protected Resource[] deploymentResources = new Resource[0];
    protected String deploymentMode = "default";
    protected ApplicationContext applicationContext;
    protected Integer transactionSynchronizationAdapterOrder;
    private Collection<AutoDeploymentStrategy> deploymentStrategies = new ArrayList<AutoDeploymentStrategy>();
    protected volatile boolean running = false;
    protected List<String> enginesBuild = new ArrayList<String>();
    protected final Object lifeCycleMonitor = new Object();

    public SpringFormEngineConfiguration() {
        this.transactionsExternallyManaged = true;
        this.deploymentStrategies.add(new DefaultAutoDeploymentStrategy());
        this.deploymentStrategies.add(new SingleResourceAutoDeploymentStrategy());
        this.deploymentStrategies.add(new ResourceParentFolderAutoDeploymentStrategy());
    }

    public FormEngine buildFormEngine() {
        FormEngine formEngine = super.buildFormEngine();
        FormEngines.setInitialized((boolean)true);
        this.enginesBuild.add(formEngine.getName());
        return formEngine;
    }

    public void setTransactionSynchronizationAdapterOrder(Integer transactionSynchronizationAdapterOrder) {
        this.transactionSynchronizationAdapterOrder = transactionSynchronizationAdapterOrder;
    }

    public void initDefaultCommandConfig() {
        if (this.defaultCommandConfig == null) {
            this.defaultCommandConfig = new CommandConfig().setContextReusePossible(true);
        }
    }

    public CommandInterceptor createTransactionInterceptor() {
        if (this.transactionManager == null) {
            throw new FlowableException("transactionManager is required property for SpringFormEngineConfiguration, use " + StandaloneFormEngineConfiguration.class.getName() + " otherwise");
        }
        return new SpringTransactionInterceptor(this.transactionManager);
    }

    public void initTransactionContextFactory() {
        if (this.transactionContextFactory == null && this.transactionManager != null) {
            this.transactionContextFactory = new SpringTransactionContextFactory(this.transactionManager, this.transactionSynchronizationAdapterOrder);
        }
    }

    protected void autoDeployResources(FormEngine formEngine) {
        if (this.deploymentResources != null && this.deploymentResources.length > 0) {
            AutoDeploymentStrategy strategy = this.getAutoDeploymentStrategy(this.deploymentMode);
            strategy.deployResources(this.deploymentName, this.deploymentResources, formEngine.getFormRepositoryService());
        }
    }

    public FormEngineConfiguration setDataSource(DataSource dataSource) {
        if (dataSource instanceof TransactionAwareDataSourceProxy) {
            return (FormEngineConfiguration)super.setDataSource(dataSource);
        }
        TransactionAwareDataSourceProxy proxiedDataSource = new TransactionAwareDataSourceProxy(dataSource);
        return (FormEngineConfiguration)super.setDataSource((DataSource)proxiedDataSource);
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public Resource[] getDeploymentResources() {
        return this.deploymentResources;
    }

    public void setDeploymentResources(Resource[] deploymentResources) {
        this.deploymentResources = deploymentResources;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getDeploymentMode() {
        return this.deploymentMode;
    }

    public void setDeploymentMode(String deploymentMode) {
        this.deploymentMode = deploymentMode;
    }

    protected AutoDeploymentStrategy getAutoDeploymentStrategy(String mode) {
        AutoDeploymentStrategy result = new DefaultAutoDeploymentStrategy();
        for (AutoDeploymentStrategy strategy : this.deploymentStrategies) {
            if (!strategy.handlesMode(mode)) continue;
            result = strategy;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifeCycleMonitor;
        synchronized (object) {
            if (!this.isRunning()) {
                this.enginesBuild.forEach(name -> this.autoDeployResources(FormEngines.getFormEngine((String)name)));
                this.running = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifeCycleMonitor;
        synchronized (object) {
            this.running = false;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return super.getPhase() - 20;
    }
}

