/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.flowable.engine.common.impl.Page;
import org.flowable.engine.common.impl.persistence.entity.data.DataManager;
import org.flowable.idm.api.Picture;
import org.flowable.idm.api.User;
import org.flowable.idm.api.UserQuery;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.impl.UserQueryImpl;
import org.flowable.idm.engine.impl.persistence.entity.AbstractEntityManager;
import org.flowable.idm.engine.impl.persistence.entity.IdentityInfoEntity;
import org.flowable.idm.engine.impl.persistence.entity.UserEntity;
import org.flowable.idm.engine.impl.persistence.entity.UserEntityManager;
import org.flowable.idm.engine.impl.persistence.entity.data.UserDataManager;

public class UserEntityManagerImpl
extends AbstractEntityManager<UserEntity>
implements UserEntityManager {
    protected UserDataManager userDataManager;

    public UserEntityManagerImpl(IdmEngineConfiguration idmEngineConfiguration, UserDataManager userDataManager) {
        super(idmEngineConfiguration);
        this.userDataManager = userDataManager;
    }

    @Override
    protected DataManager<UserEntity> getDataManager() {
        return this.userDataManager;
    }

    @Override
    public UserEntity findById(String entityId) {
        return (UserEntity)this.userDataManager.findById(entityId);
    }

    @Override
    public User createNewUser(String userId) {
        UserEntity userEntity = (UserEntity)this.create();
        userEntity.setId(userId);
        userEntity.setRevision(0);
        return userEntity;
    }

    @Override
    public void updateUser(User updatedUser) {
        super.update((UserEntity)updatedUser);
    }

    @Override
    public void delete(UserEntity userEntity) {
        super.delete(userEntity);
        this.deletePicture(userEntity);
    }

    @Override
    public void deletePicture(User user) {
        UserEntity userEntity = (UserEntity)user;
        if (userEntity.getPictureByteArrayRef() != null) {
            userEntity.getPictureByteArrayRef().delete();
        }
    }

    @Override
    public void delete(String userId) {
        UserEntity user = this.findById(userId);
        if (user != null) {
            List<IdentityInfoEntity> identityInfos = this.getIdentityInfoEntityManager().findIdentityInfoByUserId(userId);
            for (IdentityInfoEntity identityInfo : identityInfos) {
                this.getIdentityInfoEntityManager().delete(identityInfo);
            }
            this.getMembershipEntityManager().deleteMembershipByUserId(userId);
            this.delete(user);
        }
    }

    @Override
    public List<User> findUserByQueryCriteria(UserQueryImpl query, Page page) {
        return this.userDataManager.findUserByQueryCriteria(query, page);
    }

    @Override
    public long findUserCountByQueryCriteria(UserQueryImpl query) {
        return this.userDataManager.findUserCountByQueryCriteria(query);
    }

    @Override
    public UserQuery createNewUserQuery() {
        return new UserQueryImpl(this.getCommandExecutor());
    }

    @Override
    public Boolean checkPassword(String userId, String password) {
        UserEntity user = null;
        if (userId != null) {
            user = this.findById(userId);
        }
        return user != null && password != null && password.equals(user.getPassword());
    }

    @Override
    public List<User> findUsersByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.userDataManager.findUsersByNativeQuery(parameterMap, firstResult, maxResults);
    }

    @Override
    public long findUserCountByNativeQuery(Map<String, Object> parameterMap) {
        return this.userDataManager.findUserCountByNativeQuery(parameterMap);
    }

    @Override
    public boolean isNewUser(User user) {
        return ((UserEntity)user).getRevision() == 0;
    }

    @Override
    public Picture getUserPicture(User user) {
        UserEntity userEntity = (UserEntity)user;
        return userEntity.getPicture();
    }

    @Override
    public void setUserPicture(User user, Picture picture) {
        UserEntity userEntity = (UserEntity)user;
        userEntity.setPicture(picture);
        this.userDataManager.update(userEntity);
    }

    @Override
    public List<User> findUsersByPrivilegeId(String name) {
        return this.userDataManager.findUsersByPrivilegeId(name);
    }

    public UserDataManager getUserDataManager() {
        return this.userDataManager;
    }

    public void setUserDataManager(UserDataManager userDataManager) {
        this.userDataManager = userDataManager;
    }
}

