/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.persistence.entity;

import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;
import org.flowable.idm.api.event.FlowableIdmEventType;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.delegate.event.impl.FlowableIdmEventBuilder;
import org.flowable.idm.engine.impl.persistence.entity.AbstractEntityManager;
import org.flowable.idm.engine.impl.persistence.entity.MembershipEntity;
import org.flowable.idm.engine.impl.persistence.entity.MembershipEntityManager;
import org.flowable.idm.engine.impl.persistence.entity.data.MembershipDataManager;

public class MembershipEntityManagerImpl
extends AbstractEntityManager<MembershipEntity>
implements MembershipEntityManager {
    protected MembershipDataManager membershipDataManager;

    public MembershipEntityManagerImpl(IdmEngineConfiguration idmEngineConfiguration, MembershipDataManager membershipDataManager) {
        super(idmEngineConfiguration);
        this.membershipDataManager = membershipDataManager;
    }

    @Override
    protected DataManager<MembershipEntity> getDataManager() {
        return this.membershipDataManager;
    }

    @Override
    public void createMembership(String userId, String groupId) {
        MembershipEntity membershipEntity = (MembershipEntity)this.create();
        membershipEntity.setUserId(userId);
        membershipEntity.setGroupId(groupId);
        this.insert(membershipEntity, false);
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableIdmEventBuilder.createMembershipEvent(FlowableIdmEventType.MEMBERSHIP_CREATED, groupId, userId));
        }
    }

    @Override
    public void deleteMembership(String userId, String groupId) {
        this.membershipDataManager.deleteMembership(userId, groupId);
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableIdmEventBuilder.createMembershipEvent(FlowableIdmEventType.MEMBERSHIP_DELETED, groupId, userId));
        }
    }

    @Override
    public void deleteMembershipByGroupId(String groupId) {
        this.membershipDataManager.deleteMembershipByGroupId(groupId);
    }

    @Override
    public void deleteMembershipByUserId(String userId) {
        this.membershipDataManager.deleteMembershipByUserId(userId);
    }

    public MembershipDataManager getMembershipDataManager() {
        return this.membershipDataManager;
    }

    public void setMembershipDataManager(MembershipDataManager membershipDataManager) {
        this.membershipDataManager = membershipDataManager;
    }
}

