/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.rest.service.api;

import java.util.ArrayList;
import java.util.List;
import org.flowable.common.rest.util.RestUrlBuilder;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.Privilege;
import org.flowable.idm.api.User;
import org.flowable.idm.rest.service.api.group.GroupResponse;
import org.flowable.idm.rest.service.api.group.MembershipResponse;
import org.flowable.idm.rest.service.api.privilege.PrivilegeResponse;
import org.flowable.idm.rest.service.api.user.UserResponse;

public class IdmRestResponseFactory {
    public List<UserResponse> createUserResponseList(List<User> users, boolean incudePassword) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<UserResponse> responseList = new ArrayList<UserResponse>(users.size());
        for (User instance : users) {
            responseList.add(this.createUserResponse(instance, incudePassword, urlBuilder));
        }
        return responseList;
    }

    public UserResponse createUserResponse(User user, boolean incudePassword) {
        return this.createUserResponse(user, incudePassword, this.createUrlBuilder());
    }

    public UserResponse createUserResponse(User user, boolean incudePassword, RestUrlBuilder urlBuilder) {
        UserResponse response = new UserResponse();
        response.setFirstName(user.getFirstName());
        response.setLastName(user.getLastName());
        response.setId(user.getId());
        response.setEmail(user.getEmail());
        if (incudePassword) {
            response.setPassword(user.getPassword());
        }
        return response;
    }

    public List<GroupResponse> createGroupResponseList(List<Group> groups) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<GroupResponse> responseList = new ArrayList<GroupResponse>(groups.size());
        for (Group instance : groups) {
            responseList.add(this.createGroupResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public GroupResponse createGroupResponse(Group group) {
        return this.createGroupResponse(group, this.createUrlBuilder());
    }

    public GroupResponse createGroupResponse(Group group, RestUrlBuilder urlBuilder) {
        GroupResponse response = new GroupResponse();
        response.setId(group.getId());
        response.setName(group.getName());
        response.setType(group.getType());
        return response;
    }

    public MembershipResponse createMembershipResponse(String userId, String groupId) {
        return this.createMembershipResponse(userId, groupId, this.createUrlBuilder());
    }

    public MembershipResponse createMembershipResponse(String userId, String groupId, RestUrlBuilder urlBuilder) {
        MembershipResponse response = new MembershipResponse();
        response.setGroupId(groupId);
        response.setUserId(userId);
        return response;
    }

    public List<PrivilegeResponse> createPrivilegeResponseList(List<Privilege> privileges) {
        ArrayList<PrivilegeResponse> responseList = new ArrayList<PrivilegeResponse>(privileges.size());
        for (Privilege privilege : privileges) {
            responseList.add(this.createPrivilegeResponse(privilege));
        }
        return responseList;
    }

    public PrivilegeResponse createPrivilegeResponse(Privilege privilege) {
        return new PrivilegeResponse(privilege.getId(), privilege.getName());
    }

    public PrivilegeResponse createPrivilegeResponse(Privilege privilege, List<User> users, List<Group> groups) {
        PrivilegeResponse response = this.createPrivilegeResponse(privilege);
        ArrayList<UserResponse> userResponses = new ArrayList<UserResponse>(users.size());
        for (User user : users) {
            userResponses.add(this.createUserResponse(user, false));
        }
        response.setUsers(userResponses);
        ArrayList<GroupResponse> groupResponses = new ArrayList<GroupResponse>(groups.size());
        for (Group group : groups) {
            groupResponses.add(this.createGroupResponse(group));
        }
        response.setGroups(groupResponses);
        return response;
    }

    protected RestUrlBuilder createUrlBuilder() {
        return RestUrlBuilder.fromCurrentRequest();
    }
}

