/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.rest.service.api.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.api.User;
import org.flowable.idm.rest.service.api.IdmRestResponseFactory;
import org.flowable.idm.rest.service.api.user.UserRequest;
import org.flowable.idm.rest.service.api.user.UserResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Users"}, description="Manage Users", authorizations={@Authorization(value="basicAuth")})
public class UserResource {
    @Autowired
    protected IdmRestResponseFactory restResponseFactory;
    @Autowired
    protected IdmIdentityService identityService;

    protected User getUserFromRequest(String userId) {
        User user = (User)this.identityService.createUserQuery().userId(userId).singleResult();
        if (user == null) {
            throw new FlowableObjectNotFoundException("Could not find a user with id '" + userId + "'.", User.class);
        }
        return user;
    }

    @ApiOperation(value="Get a single user", tags={"Users"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the user exists and is returned."), @ApiResponse(code=404, message="Indicates the requested user does not exist.")})
    @GetMapping(value={"/users/{userId}"}, produces={"application/json"})
    public UserResponse getUser(@ApiParam(name="userId") @PathVariable String userId, HttpServletRequest request) {
        return this.restResponseFactory.createUserResponse(this.getUserFromRequest(userId), false);
    }

    @ApiOperation(value="Update a user", tags={"Users"}, notes="All request values are optional. For example, you can only include the firstName attribute in the request body JSON-object, only updating the firstName of the user, leaving all other fields unaffected. When an attribute is explicitly included and is set to null, the user-value will be updated to null. Example: {\"firstName\" : null} will clear the firstName of the user).")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the user was updated."), @ApiResponse(code=404, message="Indicates the requested user was not found."), @ApiResponse(code=409, message="Indicates the requested user was updated simultaneously.")})
    @PutMapping(value={"/users/{userId}"}, produces={"application/json"})
    public UserResponse updateUser(@ApiParam(name="userId") @PathVariable String userId, @RequestBody UserRequest userRequest, HttpServletRequest request) {
        User user = this.getUserFromRequest(userId);
        if (userRequest.isEmailChanged()) {
            user.setEmail(userRequest.getEmail());
        }
        if (userRequest.isFirstNameChanged()) {
            user.setFirstName(userRequest.getFirstName());
        }
        if (userRequest.isLastNameChanged()) {
            user.setLastName(userRequest.getLastName());
        }
        if (userRequest.isPasswordChanged()) {
            user.setPassword(userRequest.getPassword());
            this.identityService.updateUserPassword(user);
        } else {
            this.identityService.saveUser(user);
        }
        return this.restResponseFactory.createUserResponse(user, false);
    }

    @ApiOperation(value="Delete a user", tags={"Users"})
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the user was found and  has been deleted. Response-body is intentionally empty."), @ApiResponse(code=404, message="Indicates the requested user was not found.")})
    @DeleteMapping(value={"/users/{userId}"})
    public void deleteUser(@ApiParam(name="userId") @PathVariable String userId, HttpServletResponse response) {
        User user = this.getUserFromRequest(userId);
        this.identityService.deleteUser(user.getId());
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }
}

