/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.rest.service.api.privilege;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.common.rest.api.PaginateListUtil;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.api.Privilege;
import org.flowable.idm.api.PrivilegeQuery;
import org.flowable.idm.rest.service.api.IdmRestApiInterceptor;
import org.flowable.idm.rest.service.api.IdmRestResponseFactory;
import org.flowable.idm.rest.service.api.group.GroupResponse;
import org.flowable.idm.rest.service.api.privilege.AddGroupPrivilegeRequest;
import org.flowable.idm.rest.service.api.privilege.AddUserPrivilegeRequest;
import org.flowable.idm.rest.service.api.privilege.PrivilegeResponse;
import org.flowable.idm.rest.service.api.user.UserResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Privileges"}, description="Manage Privileges", authorizations={@Authorization(value="basicAuth")})
public class PrivilegeCollectionResource {
    @Autowired
    protected IdmIdentityService identityService;
    @Autowired
    protected IdmRestResponseFactory idmRestResponseFactory;
    @Autowired(required=false)
    protected IdmRestApiInterceptor restApiInterceptor;

    @ApiOperation(value="List privileges", nickname="listPrivileges", tags={"Privileges"}, produces="application/json")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", dataType="string", value="Only return privileges with the given id", paramType="query"), @ApiImplicitParam(name="name", dataType="string", value="Only return privileges with the given name", paramType="query"), @ApiImplicitParam(name="userId", dataType="string", value="Only return privileges with the given userId", paramType="query"), @ApiImplicitParam(name="groupId", dataType="string", value="Only return privileges with the given groupId", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the requested privileges were returned.")})
    @RequestMapping(value={"/privileges"}, method={RequestMethod.GET})
    public DataResponse<PrivilegeResponse> getPrivileges(@ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request) {
        PrivilegeQuery query = this.identityService.createPrivilegeQuery();
        if (allRequestParams.containsKey("id")) {
            query.privilegeId(allRequestParams.get("id"));
        }
        if (allRequestParams.containsKey("name")) {
            query.privilegeName(allRequestParams.get("name"));
        }
        if (allRequestParams.containsKey("userId")) {
            query.userId(allRequestParams.get("userId"));
        }
        if (allRequestParams.containsKey("groupId")) {
            query.groupId(allRequestParams.get("groupId"));
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessPrivilegeInfoWithQuery(query);
        }
        return PaginateListUtil.paginateList(allRequestParams, (Query)query, (String)"id", null, this.idmRestResponseFactory::createPrivilegeResponseList);
    }

    @ApiOperation(value="List all users for a given privilege", nickname="listPrivilegeUsers", tags={"Privileges"}, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the privilege exists and its users are returned.")})
    @RequestMapping(value={"/privileges/{privilegeId}/users"}, method={RequestMethod.GET})
    public List<UserResponse> getUsers(@PathVariable String privilegeId) {
        Privilege privilege = this.getPrivilegeById(privilegeId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessPrivilegeInfoById(privilege);
        }
        List users = this.identityService.getUsersWithPrivilege(privilegeId);
        return this.idmRestResponseFactory.createUserResponseList(users, false);
    }

    @ApiOperation(value="Deletes a privilege for a user", nickname="deleteUserPrivilege", tags={"Privileges"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the user privilege has been deleted")})
    @RequestMapping(value={"/privileges/{privilegeId}/users/{userId}"}, method={RequestMethod.DELETE})
    public void deleteUserPrivilege(@PathVariable String privilegeId, @PathVariable String userId) {
        Privilege privilege = this.getPrivilegeById(privilegeId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.deleteUserPrivilege(privilege, userId);
        }
        this.identityService.deleteUserPrivilegeMapping(privilegeId, userId);
    }

    @ApiOperation(value="Adds a privilege for a user", nickname="addUserPrivilege", tags={"Privileges"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the user privilege has been added")})
    @RequestMapping(value={"privileges/{privilegeId}/users"}, method={RequestMethod.POST})
    public void addUserPrivilege(@PathVariable String privilegeId, @RequestBody AddUserPrivilegeRequest request) {
        Privilege privilege = this.getPrivilegeById(privilegeId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.addUserPrivilege(privilege, request.getUserId());
        }
        this.identityService.addUserPrivilegeMapping(privilegeId, request.getUserId());
    }

    @ApiOperation(value="List all groups for a given privilege", nickname="listPrivilegeGroups", tags={"Privileges"}, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the privilege exists and its groups are returned.")})
    @RequestMapping(value={"/privileges/{privilegeId}/groups"}, method={RequestMethod.GET})
    public List<GroupResponse> getGroups(@PathVariable String privilegeId) {
        Privilege privilege = this.getPrivilegeById(privilegeId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessPrivilegeInfoById(privilege);
        }
        List groups = this.identityService.getGroupsWithPrivilege(privilegeId);
        return this.idmRestResponseFactory.createGroupResponseList(groups);
    }

    @ApiOperation(value="Deletes a privilege for a group", nickname="deleteGroupPrivilege", tags={"Privileges"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the group privilege has been deleted")})
    @RequestMapping(value={"/privileges/{privilegeId}/group/{groupId}"}, method={RequestMethod.DELETE})
    public void deleteGroupPrivilege(@PathVariable String privilegeId, @PathVariable String groupId) {
        Privilege privilege = this.getPrivilegeById(privilegeId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.deleteGroupPrivilege(privilege, groupId);
        }
        this.identityService.deleteUserPrivilegeMapping(privilegeId, groupId);
    }

    @ApiOperation(value="Adds a privilege for a group", nickname="addGroupPrivilege", tags={"Privileges"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the group privilege has been added")})
    @RequestMapping(value={"privileges/{privilegeId}/groups"}, method={RequestMethod.POST})
    public void addGroupPrivilege(@PathVariable String privilegeId, @RequestBody AddGroupPrivilegeRequest request) {
        Privilege privilege = this.getPrivilegeById(privilegeId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.addGroupPrivilege(privilege, request.getGroupId());
        }
        this.identityService.addGroupPrivilegeMapping(privilegeId, request.getGroupId());
    }

    protected Privilege getPrivilegeById(String privilegeId) {
        Privilege privilege = (Privilege)this.identityService.createPrivilegeQuery().privilegeId(privilegeId).singleResult();
        if (privilege == null) {
            throw new FlowableObjectNotFoundException("Could not find privilege with id " + privilegeId, Privilege.class);
        }
        return privilege;
    }
}

