/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.executor.jms;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.asyncexecutor.AsyncRunnableExecutionExceptionHandler;
import org.flowable.job.service.impl.asyncexecutor.ExecuteAsyncRunnable;
import org.flowable.job.service.impl.asyncexecutor.UnacquireAsyncHistoryJobExceptionHandler;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryJobMessageListener
implements MessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(HistoryJobMessageListener.class);
    protected JobServiceConfiguration jobServiceConfiguration;
    protected AsyncRunnableExecutionExceptionHandler exceptionHandler = new UnacquireAsyncHistoryJobExceptionHandler();

    public void onMessage(Message message) {
        try {
            if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                String jobId = textMessage.getText();
                ExecuteAsyncRunnable executeAsyncRunnable = new ExecuteAsyncRunnable(jobId, this.jobServiceConfiguration, (JobInfoEntityManager)this.jobServiceConfiguration.getHistoryJobEntityManager(), this.exceptionHandler);
                executeAsyncRunnable.run();
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception when handling message from job queue", (Throwable)e);
        }
    }

    public JobServiceConfiguration getJobServiceConfiguration() {
        return this.jobServiceConfiguration;
    }

    public void setJobServiceConfiguration(JobServiceConfiguration jobServiceConfiguration) {
        this.jobServiceConfiguration = jobServiceConfiguration;
    }
}

