/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.executor.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.flowable.job.api.HistoryJob;
import org.flowable.job.api.JobInfo;
import org.flowable.job.service.impl.asyncexecutor.message.AbstractMessageBasedJobManager;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class MessageBasedJobManager
extends AbstractMessageBasedJobManager {
    protected JmsTemplate jmsTemplate;
    protected JmsTemplate historyJmsTemplate;

    protected void sendMessage(final JobInfo job) {
        JmsTemplate actualJmsTemplate = job instanceof HistoryJob ? this.historyJmsTemplate : this.jmsTemplate;
        actualJmsTemplate.send(new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                return session.createTextMessage(job.getId());
            }
        });
    }

    public JmsTemplate getJmsTemplate() {
        return this.jmsTemplate;
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public JmsTemplate getHistoryJmsTemplate() {
        return this.historyJmsTemplate;
    }

    public void setHistoryJmsTemplate(JmsTemplate historyJmsTemplate) {
        this.historyJmsTemplate = historyJmsTemplate;
    }
}

