/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor;

import org.flowable.engine.common.impl.cfg.TransactionPropagation;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandConfig;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.interceptor.CommandContextCloseListener;
import org.flowable.engine.common.impl.interceptor.CommandExecutor;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntity;
import org.flowable.job.service.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncJobAddedNotification
implements CommandContextCloseListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncJobAddedNotification.class);
    protected JobInfoEntity job;
    protected AsyncExecutor asyncExecutor;

    public AsyncJobAddedNotification(JobInfoEntity job, AsyncExecutor asyncExecutor) {
        this.job = job;
        this.asyncExecutor = asyncExecutor;
    }

    public void closed(CommandContext commandContext) {
        CommandExecutor commandExecutor = CommandContextUtil.getJobServiceConfiguration(commandContext).getCommandExecutor();
        CommandConfig commandConfig = new CommandConfig(false, TransactionPropagation.REQUIRES_NEW);
        commandExecutor.execute(commandConfig, (Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("notifying job executor of new job");
                }
                AsyncJobAddedNotification.this.asyncExecutor.executeAsyncJob(AsyncJobAddedNotification.this.job);
                return null;
            }
        });
    }

    public void closing(CommandContext commandContext) {
    }

    public void afterSessionsFlush(CommandContext commandContext) {
    }

    public void closeFailure(CommandContext commandContext) {
    }
}

