/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.interceptor.CommandContextCloseListener;
import org.flowable.job.api.Job;
import org.flowable.job.api.JobInfo;
import org.flowable.job.api.JobNotFoundException;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.asyncexecutor.FailedJobListener;
import org.flowable.job.service.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteJobCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteJobCmd.class);
    protected String jobId;

    public ExecuteJobCmd(String jobId) {
        this.jobId = jobId;
    }

    public Object execute(CommandContext commandContext) {
        if (this.jobId == null) {
            throw new FlowableIllegalArgumentException("jobId and job is null");
        }
        Job job = (Job)CommandContextUtil.getJobEntityManager(commandContext).findById(this.jobId);
        if (job == null) {
            throw new JobNotFoundException(this.jobId);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing job {}", (Object)job.getId());
        }
        JobServiceConfiguration jobServiceConfiguration = CommandContextUtil.getJobServiceConfiguration(commandContext);
        if (job.getProcessDefinitionId() != null && jobServiceConfiguration.getInternalJobManager() != null && jobServiceConfiguration.getInternalJobManager().isFlowable5ProcessDefinitionId(job.getProcessDefinitionId())) {
            jobServiceConfiguration.getInternalJobManager().executeV5Job(job);
            return null;
        }
        commandContext.addCloseListener((CommandContextCloseListener)new FailedJobListener(jobServiceConfiguration.getCommandExecutor(), job));
        try {
            CommandContextUtil.getJobManager(commandContext).execute((JobInfo)job);
        }
        catch (Throwable exception) {
            throw new FlowableException("Job " + this.jobId + " failed", exception);
        }
        return null;
    }

    public String getJobId() {
        return this.jobId;
    }
}

