/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.delegate.event.FlowableEngineEventType;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.api.delegate.event.FlowableEventDispatcher;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.job.service.event.impl.FlowableJobEventBuilder;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntity;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntityManager;
import org.flowable.job.service.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteAsyncJobCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteAsyncJobCmd.class);
    protected String jobId;
    protected JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager;

    public ExecuteAsyncJobCmd(String jobId) {
        this.jobId = jobId;
    }

    public ExecuteAsyncJobCmd(String jobId, JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager) {
        this.jobId = jobId;
        this.jobEntityManager = jobEntityManager;
    }

    public Object execute(CommandContext commandContext) {
        if (this.jobEntityManager == null) {
            this.jobEntityManager = CommandContextUtil.getJobEntityManager(commandContext);
        }
        if (this.jobId == null) {
            throw new FlowableIllegalArgumentException("jobId is null");
        }
        JobInfoEntity job = (JobInfoEntity)this.jobEntityManager.findById(this.jobId);
        if (job == null) {
            LOGGER.debug("Job does not exist anymore and will not be executed. It has most likely been deleted as part of another concurrent part of the process instance.");
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing async job {}", (Object)job.getId());
        }
        CommandContextUtil.getJobManager(commandContext).execute(job);
        FlowableEventDispatcher eventDispatcher = CommandContextUtil.getEventDispatcher(commandContext);
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_EXECUTION_SUCCESS, job));
        }
        return null;
    }
}

