/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.job.api.Job;
import org.flowable.job.api.JobNotFoundException;
import org.flowable.job.service.impl.persistence.entity.SuspendedJobEntity;
import org.flowable.job.service.impl.util.CommandContextUtil;

public class MoveSuspendedJobToExecutableJobCmd
implements Command<Job>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String jobId;

    public MoveSuspendedJobToExecutableJobCmd(String jobId) {
        this.jobId = jobId;
    }

    public Job execute(CommandContext commandContext) {
        if (this.jobId == null) {
            throw new FlowableIllegalArgumentException("jobId and job is null");
        }
        SuspendedJobEntity job = (SuspendedJobEntity)CommandContextUtil.getSuspendedJobEntityManager(commandContext).findById(this.jobId);
        if (job == null) {
            throw new JobNotFoundException(this.jobId);
        }
        return CommandContextUtil.getJobServiceConfiguration().getJobService().activateSuspendedJob(job);
    }

    public String getJobId() {
        return this.jobId;
    }
}

