/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor;

import java.util.LinkedList;
import java.util.UUID;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.job.api.JobInfo;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.asyncexecutor.AcquireAsyncJobsDueRunnable;
import org.flowable.job.service.impl.asyncexecutor.AcquireTimerJobsRunnable;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.flowable.job.service.impl.asyncexecutor.AsyncRunnableExecutionExceptionHandler;
import org.flowable.job.service.impl.asyncexecutor.ExecuteAsyncRunnable;
import org.flowable.job.service.impl.asyncexecutor.ExecuteAsyncRunnableFactory;
import org.flowable.job.service.impl.asyncexecutor.ResetExpiredJobsRunnable;
import org.flowable.job.service.impl.cmd.UnacquireOwnedJobsCmd;
import org.flowable.job.service.impl.persistence.entity.JobEntityManager;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntity;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntityManager;
import org.flowable.job.service.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAsyncExecutor
implements AsyncExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAsyncExecutor.class);
    protected boolean timerRunnableNeeded = true;
    protected AcquireTimerJobsRunnable timerJobRunnable;
    protected String acquireRunnableThreadName;
    protected JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager;
    protected AcquireAsyncJobsDueRunnable asyncJobsDueRunnable;
    protected String resetExpiredRunnableName;
    protected ResetExpiredJobsRunnable resetExpiredJobsRunnable;
    protected ExecuteAsyncRunnableFactory executeAsyncRunnableFactory;
    protected AsyncRunnableExecutionExceptionHandler asyncRunnableExecutionExceptionHandler;
    protected boolean isAutoActivate;
    protected boolean isActive;
    protected boolean isMessageQueueMode;
    protected int maxTimerJobsPerAcquisition = 1;
    protected int maxAsyncJobsDuePerAcquisition = 1;
    protected int defaultTimerJobAcquireWaitTimeInMillis = 10000;
    protected int defaultAsyncJobAcquireWaitTimeInMillis = 10000;
    protected int defaultQueueSizeFullWaitTime;
    protected String lockOwner = UUID.randomUUID().toString();
    protected int timerLockTimeInMillis = 300000;
    protected int asyncJobLockTimeInMillis = 300000;
    protected int retryWaitTimeInMillis = 500;
    protected int resetExpiredJobsInterval = 60000;
    protected int resetExpiredJobsPageSize = 3;
    protected LinkedList<JobInfo> temporaryJobQueue = new LinkedList();
    protected JobServiceConfiguration jobServiceConfiguration;

    @Override
    public boolean executeAsyncJob(JobInfo job) {
        if (this.isMessageQueueMode) {
            return true;
        }
        Runnable runnable = null;
        if (this.isActive) {
            runnable = this.createRunnableForJob(job);
            return this.executeAsyncJob(job, runnable);
        }
        this.temporaryJobQueue.add(job);
        return true;
    }

    protected abstract boolean executeAsyncJob(JobInfo var1, Runnable var2);

    protected void unlockOwnedJobs() {
        this.jobServiceConfiguration.getCommandExecutor().execute((Command)new UnacquireOwnedJobsCmd(this.lockOwner, null));
    }

    protected Runnable createRunnableForJob(JobInfo job) {
        if (this.executeAsyncRunnableFactory == null) {
            return new ExecuteAsyncRunnable(job, this.jobServiceConfiguration, this.jobEntityManager, this.asyncRunnableExecutionExceptionHandler);
        }
        return this.executeAsyncRunnableFactory.createExecuteAsyncRunnable(job, this.jobServiceConfiguration);
    }

    @Override
    public void start() {
        if (this.isActive) {
            return;
        }
        this.isActive = true;
        LOGGER.info("Starting up the async job executor [{}].", (Object)this.getClass().getName());
        this.initializeJobEntityManager();
        this.initializeRunnables();
        this.startAdditionalComponents();
        this.executeTemporaryJobs();
    }

    protected void initializeJobEntityManager() {
        if (this.jobEntityManager == null) {
            this.jobEntityManager = this.jobServiceConfiguration.getJobEntityManager();
        }
    }

    protected void initializeRunnables() {
        JobEntityManager jobEntityManagerToUse;
        if (this.timerRunnableNeeded && this.timerJobRunnable == null) {
            this.timerJobRunnable = new AcquireTimerJobsRunnable(this, this.jobServiceConfiguration.getJobManager());
        }
        JobEntityManager jobEntityManager = jobEntityManagerToUse = this.jobEntityManager != null ? this.jobEntityManager : CommandContextUtil.getJobServiceConfiguration().getJobEntityManager();
        if (this.resetExpiredJobsRunnable == null) {
            String resetRunnableName = this.resetExpiredRunnableName != null ? this.resetExpiredRunnableName : "flowable-reset-expired-jobs";
            this.resetExpiredJobsRunnable = new ResetExpiredJobsRunnable(resetRunnableName, this, jobEntityManagerToUse);
        }
        if (!this.isMessageQueueMode && this.asyncJobsDueRunnable == null) {
            String acquireJobsRunnableName = this.acquireRunnableThreadName != null ? this.acquireRunnableThreadName : "flowable-acquire-async-jobs";
            this.asyncJobsDueRunnable = new AcquireAsyncJobsDueRunnable(acquireJobsRunnableName, this, jobEntityManagerToUse);
        }
    }

    protected abstract void startAdditionalComponents();

    protected void executeTemporaryJobs() {
        while (!this.temporaryJobQueue.isEmpty()) {
            JobInfo job = this.temporaryJobQueue.pop();
            this.executeAsyncJob(job);
        }
    }

    @Override
    public synchronized void shutdown() {
        if (!this.isActive) {
            return;
        }
        LOGGER.info("Shutting down the async job executor [{}].", (Object)this.getClass().getName());
        this.stopRunnables();
        this.shutdownAdditionalComponents();
        this.isActive = false;
    }

    protected void stopRunnables() {
        if (this.timerJobRunnable != null) {
            this.timerJobRunnable.stop();
        }
        if (this.asyncJobsDueRunnable != null) {
            this.asyncJobsDueRunnable.stop();
        }
        if (this.resetExpiredJobsRunnable != null) {
            this.resetExpiredJobsRunnable.stop();
        }
        this.timerJobRunnable = null;
        this.asyncJobsDueRunnable = null;
        this.resetExpiredJobsRunnable = null;
    }

    protected abstract void shutdownAdditionalComponents();

    @Override
    public JobServiceConfiguration getJobServiceConfiguration() {
        return this.jobServiceConfiguration;
    }

    @Override
    public void setJobServiceConfiguration(JobServiceConfiguration jobServiceConfiguration) {
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    @Override
    public boolean isAutoActivate() {
        return this.isAutoActivate;
    }

    @Override
    public void setAutoActivate(boolean isAutoActivate) {
        this.isAutoActivate = isAutoActivate;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public boolean isMessageQueueMode() {
        return this.isMessageQueueMode;
    }

    public void setMessageQueueMode(boolean isMessageQueueMode) {
        this.isMessageQueueMode = isMessageQueueMode;
    }

    @Override
    public String getLockOwner() {
        return this.lockOwner;
    }

    public void setLockOwner(String lockOwner) {
        this.lockOwner = lockOwner;
    }

    @Override
    public int getTimerLockTimeInMillis() {
        return this.timerLockTimeInMillis;
    }

    @Override
    public void setTimerLockTimeInMillis(int timerLockTimeInMillis) {
        this.timerLockTimeInMillis = timerLockTimeInMillis;
    }

    @Override
    public int getAsyncJobLockTimeInMillis() {
        return this.asyncJobLockTimeInMillis;
    }

    @Override
    public void setAsyncJobLockTimeInMillis(int asyncJobLockTimeInMillis) {
        this.asyncJobLockTimeInMillis = asyncJobLockTimeInMillis;
    }

    @Override
    public int getMaxTimerJobsPerAcquisition() {
        return this.maxTimerJobsPerAcquisition;
    }

    @Override
    public void setMaxTimerJobsPerAcquisition(int maxTimerJobsPerAcquisition) {
        this.maxTimerJobsPerAcquisition = maxTimerJobsPerAcquisition;
    }

    @Override
    public int getMaxAsyncJobsDuePerAcquisition() {
        return this.maxAsyncJobsDuePerAcquisition;
    }

    @Override
    public void setMaxAsyncJobsDuePerAcquisition(int maxAsyncJobsDuePerAcquisition) {
        this.maxAsyncJobsDuePerAcquisition = maxAsyncJobsDuePerAcquisition;
    }

    @Override
    public int getDefaultTimerJobAcquireWaitTimeInMillis() {
        return this.defaultTimerJobAcquireWaitTimeInMillis;
    }

    @Override
    public void setDefaultTimerJobAcquireWaitTimeInMillis(int defaultTimerJobAcquireWaitTimeInMillis) {
        this.defaultTimerJobAcquireWaitTimeInMillis = defaultTimerJobAcquireWaitTimeInMillis;
    }

    @Override
    public int getDefaultAsyncJobAcquireWaitTimeInMillis() {
        return this.defaultAsyncJobAcquireWaitTimeInMillis;
    }

    @Override
    public void setDefaultAsyncJobAcquireWaitTimeInMillis(int defaultAsyncJobAcquireWaitTimeInMillis) {
        this.defaultAsyncJobAcquireWaitTimeInMillis = defaultAsyncJobAcquireWaitTimeInMillis;
    }

    public void setTimerJobRunnable(AcquireTimerJobsRunnable timerJobRunnable) {
        this.timerJobRunnable = timerJobRunnable;
    }

    @Override
    public int getDefaultQueueSizeFullWaitTimeInMillis() {
        return this.defaultQueueSizeFullWaitTime;
    }

    @Override
    public void setDefaultQueueSizeFullWaitTimeInMillis(int defaultQueueSizeFullWaitTime) {
        this.defaultQueueSizeFullWaitTime = defaultQueueSizeFullWaitTime;
    }

    public void setAsyncJobsDueRunnable(AcquireAsyncJobsDueRunnable asyncJobsDueRunnable) {
        this.asyncJobsDueRunnable = asyncJobsDueRunnable;
    }

    public void setTimerRunnableNeeded(boolean timerRunnableNeeded) {
        this.timerRunnableNeeded = timerRunnableNeeded;
    }

    public void setAcquireRunnableThreadName(String acquireRunnableThreadName) {
        this.acquireRunnableThreadName = acquireRunnableThreadName;
    }

    public void setJobEntityManager(JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager) {
        this.jobEntityManager = jobEntityManager;
    }

    public void setResetExpiredRunnableName(String resetExpiredRunnableName) {
        this.resetExpiredRunnableName = resetExpiredRunnableName;
    }

    public void setResetExpiredJobsRunnable(ResetExpiredJobsRunnable resetExpiredJobsRunnable) {
        this.resetExpiredJobsRunnable = resetExpiredJobsRunnable;
    }

    @Override
    public int getRetryWaitTimeInMillis() {
        return this.retryWaitTimeInMillis;
    }

    @Override
    public void setRetryWaitTimeInMillis(int retryWaitTimeInMillis) {
        this.retryWaitTimeInMillis = retryWaitTimeInMillis;
    }

    @Override
    public int getResetExpiredJobsInterval() {
        return this.resetExpiredJobsInterval;
    }

    @Override
    public void setResetExpiredJobsInterval(int resetExpiredJobsInterval) {
        this.resetExpiredJobsInterval = resetExpiredJobsInterval;
    }

    @Override
    public int getResetExpiredJobsPageSize() {
        return this.resetExpiredJobsPageSize;
    }

    @Override
    public void setResetExpiredJobsPageSize(int resetExpiredJobsPageSize) {
        this.resetExpiredJobsPageSize = resetExpiredJobsPageSize;
    }

    public ExecuteAsyncRunnableFactory getExecuteAsyncRunnableFactory() {
        return this.executeAsyncRunnableFactory;
    }

    public void setExecuteAsyncRunnableFactory(ExecuteAsyncRunnableFactory executeAsyncRunnableFactory) {
        this.executeAsyncRunnableFactory = executeAsyncRunnableFactory;
    }

    public AsyncRunnableExecutionExceptionHandler getAsyncRunnableExecutionExceptionHandler() {
        return this.asyncRunnableExecutionExceptionHandler;
    }

    public void setAsyncRunnableExecutionExceptionHandler(AsyncRunnableExecutionExceptionHandler asyncRunnableExecutionExceptionHandler) {
        this.asyncRunnableExecutionExceptionHandler = asyncRunnableExecutionExceptionHandler;
    }
}

