/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.history.async;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.impl.history.async.AbstractAsyncHistoryJobHandler;
import org.flowable.job.service.impl.history.async.AsyncHistoryJobNotApplicableException;
import org.flowable.job.service.impl.history.async.transformer.HistoryJsonTransformer;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHistoryJobHandler
extends AbstractAsyncHistoryJobHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncHistoryJobHandler.class);
    protected Map<String, List<HistoryJsonTransformer>> historyJsonTransformers = new HashMap<String, List<HistoryJsonTransformer>>();

    public AsyncHistoryJobHandler(String jobType) {
        super(jobType);
    }

    public void addHistoryJsonTransformer(HistoryJsonTransformer historyJsonTransformer) {
        String type = historyJsonTransformer.getType();
        if (!this.historyJsonTransformers.containsKey(type)) {
            this.historyJsonTransformers.put(type, new ArrayList());
        }
        this.historyJsonTransformers.get(historyJsonTransformer.getType()).add(historyJsonTransformer);
    }

    @Override
    protected void processHistoryJson(CommandContext commandContext, HistoryJobEntity job, JsonNode historyNode) {
        List<HistoryJsonTransformer> transformers;
        String type = historyNode.get("type").asText();
        ObjectNode historicalJsonData = (ObjectNode)historyNode.get("data");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Handling async history job (id={}, type={})", (Object)job.getId(), (Object)type);
        }
        if ((transformers = this.historyJsonTransformers.get(type)) != null && !transformers.isEmpty()) {
            for (HistoryJsonTransformer transformer : transformers) {
                if (transformer.isApplicable(historicalJsonData, commandContext)) {
                    transformer.transformJson(job, historicalJsonData, commandContext);
                    continue;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Could not handle history job (id={}) for transformer {}. as it is not applicable. Unacquiring. {}", new Object[]{job.getId(), transformer.getType(), historicalJsonData});
                }
                throw new AsyncHistoryJobNotApplicableException();
            }
        } else {
            LOGGER.debug("Cannot transform history json: no transformers found for type {}", (Object)type);
        }
    }

    public Map<String, List<HistoryJsonTransformer>> getHistoryJsonTransformers() {
        return this.historyJsonTransformers;
    }

    public void setHistoryJsonTransformers(Map<String, List<HistoryJsonTransformer>> historyJsonTransformers) {
        this.historyJsonTransformers = historyJsonTransformers;
    }
}

