/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.history.async;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.impl.history.async.AbstractAsyncHistoryJobHandler;
import org.flowable.job.service.impl.history.async.AsyncHistoryJobNotApplicableException;
import org.flowable.job.service.impl.history.async.transformer.HistoryJsonTransformer;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;

public class AsyncHistoryJobHandler
extends AbstractAsyncHistoryJobHandler {
    protected Map<String, List<HistoryJsonTransformer>> historyJsonTransformers = new HashMap<String, List<HistoryJsonTransformer>>();
    protected HistoryJsonTransformer defaultHistoryJsonTransformer;

    public AsyncHistoryJobHandler(String jobType) {
        super(jobType);
    }

    public void addHistoryJsonTransformer(HistoryJsonTransformer historyJsonTransformer) {
        List<String> types = historyJsonTransformer.getTypes();
        for (String type : types) {
            if (!this.historyJsonTransformers.containsKey(type)) {
                this.historyJsonTransformers.put(type, new ArrayList());
            }
            this.historyJsonTransformers.get(type).add(historyJsonTransformer);
        }
    }

    @Override
    protected void processHistoryJson(CommandContext commandContext, HistoryJobEntity job, JsonNode historyNode) {
        List<HistoryJsonTransformer> transformers;
        String type = null;
        if (historyNode.has("type")) {
            type = historyNode.get("type").asText();
        }
        ObjectNode historicalJsonData = (ObjectNode)historyNode.get("data");
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Handling async history job (id={}, type={})", (Object)job.getId(), (Object)type);
        }
        if ((transformers = this.historyJsonTransformers.get(type)) != null && !transformers.isEmpty()) {
            this.executeHistoryTransformers(commandContext, job, historicalJsonData, transformers);
        } else {
            this.handleNoMatchingHistoryTransformer(commandContext, job, historicalJsonData, type);
        }
    }

    protected void executeHistoryTransformers(CommandContext commandContext, HistoryJobEntity job, ObjectNode historicalJsonData, List<HistoryJsonTransformer> transformers) {
        for (HistoryJsonTransformer transformer : transformers) {
            if (transformer.isApplicable(historicalJsonData, commandContext)) {
                transformer.transformJson(job, historicalJsonData, commandContext);
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Could not handle history job (id={}) for transformer {}. as it is not applicable. Unacquiring. {}", new Object[]{job.getId(), transformer.getTypes(), historicalJsonData});
            }
            throw new AsyncHistoryJobNotApplicableException("Job is not applicable for transformer types: " + transformer.getTypes());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleNoMatchingHistoryTransformer(CommandContext commandContext, HistoryJobEntity job, ObjectNode historicalData, String type) {
        if (this.defaultHistoryJsonTransformer != null) {
            if (!this.defaultHistoryJsonTransformer.isApplicable(historicalData, commandContext)) throw new AsyncHistoryJobNotApplicableException("Job is not applicable for default history json transformer types: " + this.defaultHistoryJsonTransformer.getTypes());
            this.defaultHistoryJsonTransformer.transformJson(job, historicalData, commandContext);
            return;
        } else {
            this.logger.warn("Cannot transform history json: no transformers found for type {}", (Object)type);
        }
    }

    public Map<String, List<HistoryJsonTransformer>> getHistoryJsonTransformers() {
        return this.historyJsonTransformers;
    }

    public void setHistoryJsonTransformers(Map<String, List<HistoryJsonTransformer>> historyJsonTransformers) {
        this.historyJsonTransformers = historyJsonTransformers;
    }

    public HistoryJsonTransformer getDefaultHistoryJsonTransformer() {
        return this.defaultHistoryJsonTransformer;
    }

    public void setDefaultHistoryJsonTransformer(HistoryJsonTransformer defaultHistoryJsonTransformer) {
        this.defaultHistoryJsonTransformer = defaultHistoryJsonTransformer;
    }
}

