/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.persistence.entity.data.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.flowable.common.engine.impl.Page;
import org.flowable.common.engine.impl.db.AbstractDataManager;
import org.flowable.common.engine.impl.db.DbSqlSession;
import org.flowable.common.engine.impl.db.ListQueryParameterObject;
import org.flowable.common.engine.impl.persistence.cache.CachedEntityMatcher;
import org.flowable.job.api.Job;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.JobQueryImpl;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.JobEntityImpl;
import org.flowable.job.service.impl.persistence.entity.data.JobDataManager;
import org.flowable.job.service.impl.persistence.entity.data.impl.cachematcher.JobsByExecutionIdMatcher;

public class MybatisJobDataManager
extends AbstractDataManager<JobEntity>
implements JobDataManager {
    protected JobServiceConfiguration jobServiceConfiguration;
    protected CachedEntityMatcher<JobEntity> jobsByExecutionIdMatcher = new JobsByExecutionIdMatcher();

    public MybatisJobDataManager() {
    }

    public MybatisJobDataManager(JobServiceConfiguration jobServiceConfiguration) {
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public Class<? extends JobEntity> getManagedEntityClass() {
        return JobEntityImpl.class;
    }

    public JobEntity create() {
        return new JobEntityImpl();
    }

    @Override
    public List<JobEntity> findJobsToExecute(Page page) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("jobExecutionScope", this.jobServiceConfiguration.getJobExecutionScope());
        return this.getDbSqlSession().selectList("selectJobsToExecute", params, page);
    }

    @Override
    public List<JobEntity> findJobsByExecutionId(String executionId) {
        DbSqlSession dbSqlSession = this.getDbSqlSession();
        if (this.isEntityInserted(dbSqlSession, "execution", executionId)) {
            return this.getListFromCache(this.jobsByExecutionIdMatcher, executionId);
        }
        return this.getList(dbSqlSession, "selectJobsByExecutionId", executionId, this.jobsByExecutionIdMatcher, true);
    }

    @Override
    public List<JobEntity> findJobsByProcessInstanceId(String processInstanceId) {
        return this.getDbSqlSession().selectList("selectJobsByProcessInstanceId", (Object)processInstanceId);
    }

    @Override
    public List<JobEntity> findExpiredJobs(Page page) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("jobExecutionScope", this.jobServiceConfiguration.getJobExecutionScope());
        Date now = this.jobServiceConfiguration.getClock().getCurrentTime();
        params.put("now", now);
        Date maxTimeout = new Date(now.getTime() - (long)this.jobServiceConfiguration.getAsyncExecutorResetExpiredJobsMaxTimeout());
        params.put("maxTimeout", maxTimeout);
        return this.getDbSqlSession().selectList("selectExpiredJobs", params, page);
    }

    @Override
    public List<Job> findJobsByQueryCriteria(JobQueryImpl jobQuery) {
        String query = "selectJobByQueryCriteria";
        return this.getDbSqlSession().selectList("selectJobByQueryCriteria", (ListQueryParameterObject)jobQuery);
    }

    @Override
    public long findJobCountByQueryCriteria(JobQueryImpl jobQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectJobCountByQueryCriteria", (Object)jobQuery);
    }

    @Override
    public void updateJobTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().update("updateJobTenantIdForDeployment", params);
    }

    @Override
    public void resetExpiredJob(String jobId) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("id", jobId);
        params.put("now", this.jobServiceConfiguration.getClock().getCurrentTime());
        this.getDbSqlSession().update("resetExpiredJob", params);
    }

    @Override
    public void deleteJobsByExecutionId(String executionId) {
        DbSqlSession dbSqlSession = this.getDbSqlSession();
        if (this.isEntityInserted(dbSqlSession, "execution", executionId)) {
            this.deleteCachedEntities(dbSqlSession, this.jobsByExecutionIdMatcher, executionId);
        } else {
            this.bulkDelete("deleteJobsByExecutionId", this.jobsByExecutionIdMatcher, executionId);
        }
    }
}

