/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.persistence.entity;

import java.util.List;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.job.api.Job;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.event.impl.FlowableJobEventBuilder;
import org.flowable.job.service.impl.SuspendedJobQueryImpl;
import org.flowable.job.service.impl.persistence.entity.AbstractJobServiceEngineEntityManager;
import org.flowable.job.service.impl.persistence.entity.AbstractRuntimeJobEntity;
import org.flowable.job.service.impl.persistence.entity.SuspendedJobEntity;
import org.flowable.job.service.impl.persistence.entity.SuspendedJobEntityManager;
import org.flowable.job.service.impl.persistence.entity.data.SuspendedJobDataManager;

public class SuspendedJobEntityManagerImpl
extends AbstractJobServiceEngineEntityManager<SuspendedJobEntity, SuspendedJobDataManager>
implements SuspendedJobEntityManager {
    public SuspendedJobEntityManagerImpl(JobServiceConfiguration jobServiceConfiguration, SuspendedJobDataManager jobDataManager) {
        super(jobServiceConfiguration, jobDataManager);
    }

    @Override
    public List<SuspendedJobEntity> findJobsByExecutionId(String id) {
        return ((SuspendedJobDataManager)this.dataManager).findJobsByExecutionId(id);
    }

    @Override
    public List<SuspendedJobEntity> findJobsByProcessInstanceId(String id) {
        return ((SuspendedJobDataManager)this.dataManager).findJobsByProcessInstanceId(id);
    }

    @Override
    public List<Job> findJobsByQueryCriteria(SuspendedJobQueryImpl jobQuery) {
        return ((SuspendedJobDataManager)this.dataManager).findJobsByQueryCriteria(jobQuery);
    }

    @Override
    public long findJobCountByQueryCriteria(SuspendedJobQueryImpl jobQuery) {
        return ((SuspendedJobDataManager)this.dataManager).findJobCountByQueryCriteria(jobQuery);
    }

    @Override
    public void updateJobTenantIdForDeployment(String deploymentId, String newTenantId) {
        ((SuspendedJobDataManager)this.dataManager).updateJobTenantIdForDeployment(deploymentId, newTenantId);
    }

    public void insert(SuspendedJobEntity jobEntity, boolean fireCreateEvent) {
        if (((JobServiceConfiguration)this.serviceConfiguration).getInternalJobManager() != null) {
            ((JobServiceConfiguration)this.serviceConfiguration).getInternalJobManager().handleJobInsert(jobEntity);
        }
        jobEntity.setCreateTime(this.getClock().getCurrentTime());
        super.insert((Entity)jobEntity, fireCreateEvent);
    }

    public void insert(SuspendedJobEntity jobEntity) {
        this.insert(jobEntity, true);
    }

    public void delete(SuspendedJobEntity jobEntity) {
        super.delete((Entity)jobEntity, false);
        this.deleteByteArrayRef(jobEntity.getExceptionByteArrayRef());
        this.deleteByteArrayRef(jobEntity.getCustomValuesByteArrayRef());
        if (((JobServiceConfiguration)this.serviceConfiguration).getInternalJobManager() != null) {
            ((JobServiceConfiguration)this.serviceConfiguration).getInternalJobManager().handleJobDelete(jobEntity);
        }
        if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, jobEntity));
        }
    }

    protected SuspendedJobEntity createSuspendedJob(AbstractRuntimeJobEntity job) {
        SuspendedJobEntity newSuspendedJobEntity = (SuspendedJobEntity)this.create();
        newSuspendedJobEntity.setJobHandlerConfiguration(job.getJobHandlerConfiguration());
        newSuspendedJobEntity.setCustomValues(job.getCustomValues());
        newSuspendedJobEntity.setJobHandlerType(job.getJobHandlerType());
        newSuspendedJobEntity.setExclusive(job.isExclusive());
        newSuspendedJobEntity.setRepeat(job.getRepeat());
        newSuspendedJobEntity.setRetries(job.getRetries());
        newSuspendedJobEntity.setEndDate(job.getEndDate());
        newSuspendedJobEntity.setExecutionId(job.getExecutionId());
        newSuspendedJobEntity.setProcessInstanceId(job.getProcessInstanceId());
        newSuspendedJobEntity.setProcessDefinitionId(job.getProcessDefinitionId());
        newSuspendedJobEntity.setScopeId(job.getScopeId());
        newSuspendedJobEntity.setSubScopeId(job.getSubScopeId());
        newSuspendedJobEntity.setScopeType(job.getScopeType());
        newSuspendedJobEntity.setScopeDefinitionId(job.getScopeDefinitionId());
        newSuspendedJobEntity.setTenantId(job.getTenantId());
        newSuspendedJobEntity.setJobType(job.getJobType());
        return newSuspendedJobEntity;
    }
}

