/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableOptimisticLockingException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.lock.LockManager;
import org.flowable.common.engine.impl.lock.LockManagerImpl;
import org.flowable.job.service.impl.asyncexecutor.AcquireJobsRunnableConfiguration;
import org.flowable.job.service.impl.asyncexecutor.AcquireTimerLifecycleListener;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.flowable.job.service.impl.asyncexecutor.JobManager;
import org.flowable.job.service.impl.cmd.AcquireTimerJobsCmd;
import org.flowable.job.service.impl.cmd.AcquireTimerJobsWithGlobalAcquireLockCmd;
import org.flowable.job.service.impl.cmd.BulkMoveTimerJobsToExecutableJobsCmd;
import org.flowable.job.service.impl.cmd.MoveTimerJobsToExecutableJobsCmd;
import org.flowable.job.service.impl.cmd.UnlockTimerJobsCmd;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcquireTimerJobsRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AcquireTimerJobsRunnable.class);
    private static final String ACQUIRE_TIMER_JOBS_GLOBAL_LOCK = "acquireTimerJobsLock";
    private static final AcquireTimerLifecycleListener NOOP_LIFECYCLE_LISTENER = new AcquireTimerLifecycleListener(){

        @Override
        public void startAcquiring(String engineName, int maxTimerJobsPerAcquisition) {
        }

        @Override
        public void stopAcquiring(String engineName) {
        }

        @Override
        public void acquiredJobs(String engineName, int jobsAcquired, int maxTimerJobsPerAcquisition) {
        }

        @Override
        public void startWaiting(String engineName, long millisToWait) {
        }
    };
    protected final AsyncExecutor asyncExecutor;
    protected final JobManager jobManager;
    protected final AcquireTimerLifecycleListener lifecycleListener;
    protected AcquireJobsRunnableConfiguration configuration;
    protected LockManager lockManager;
    protected volatile boolean isInterrupted;
    protected final Object MONITOR = new Object();
    protected final AtomicBoolean isWaiting = new AtomicBoolean(false);
    protected final int moveExecutorPoolSize;
    protected ExecutorService moveTimerJobsExecutorService;
    protected CommandExecutor commandExecutor;

    public AcquireTimerJobsRunnable(AsyncExecutor asyncExecutor, JobManager jobManager, int moveExecutorPoolSize) {
        this(asyncExecutor, jobManager, null, AcquireJobsRunnableConfiguration.DEFAULT, moveExecutorPoolSize);
    }

    public AcquireTimerJobsRunnable(AsyncExecutor asyncExecutor, JobManager jobManager, AcquireTimerLifecycleListener lifecycleListener, AcquireJobsRunnableConfiguration configuration, int moveExecutorPoolSize) {
        this.asyncExecutor = asyncExecutor;
        this.jobManager = jobManager;
        this.lifecycleListener = lifecycleListener != null ? lifecycleListener : NOOP_LIFECYCLE_LISTENER;
        this.configuration = configuration;
        this.moveExecutorPoolSize = moveExecutorPoolSize;
    }

    @Override
    public synchronized void run() {
        this.lockManager = this.createLockManager(this.asyncExecutor.getJobServiceConfiguration().getCommandExecutor());
        LOGGER.info("starting to acquire async jobs due");
        String threadName = "flowable-" + this.getEngineName() + "-acquire-timer-jobs";
        Thread.currentThread().setName(threadName);
        this.createTimerMoveExecutorService(threadName);
        this.commandExecutor = this.asyncExecutor.getJobServiceConfiguration().getCommandExecutor();
        long millisToWait = 0L;
        while (!this.isInterrupted) {
            millisToWait = this.executeAcquireAndMoveCycle();
            if (millisToWait <= 0L) continue;
            this.sleep(millisToWait);
        }
        if (this.moveTimerJobsExecutorService != null) {
            this.moveTimerJobsExecutorService.shutdown();
        }
        LOGGER.info("stopped async job due acquisition");
    }

    protected LockManager createLockManager(CommandExecutor commandExecutor) {
        return new LockManagerImpl(commandExecutor, this.configuration.getGlobalAcquireLockPrefix() + ACQUIRE_TIMER_JOBS_GLOBAL_LOCK, this.configuration.getLockPollRate(), this.configuration.getLockForceAcquireAfter(), this.getEngineName());
    }

    protected void createTimerMoveExecutorService(String threadName) {
        BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern(threadName + "-move").build();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(this.moveExecutorPoolSize, this.moveExecutorPoolSize, 5L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1), (ThreadFactory)threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
        executor.allowCoreThreadTimeOut(true);
        this.moveTimerJobsExecutorService = executor;
    }

    protected long executeAcquireAndMoveCycle() {
        this.lifecycleListener.startAcquiring(this.getEngineName(), this.asyncExecutor.getMaxTimerJobsPerAcquisition());
        List timerJobs = Collections.emptyList();
        long millisToWait = 0L;
        try {
            boolean globalAcquireLockEnabled = this.configuration.isGlobalAcquireLockEnabled();
            if (globalAcquireLockEnabled) {
                try {
                    timerJobs = (List)this.lockManager.waitForLockRunAndRelease(this.configuration.getLockWaitTime(), () -> (List)this.commandExecutor.execute((Command)new AcquireTimerJobsWithGlobalAcquireLockCmd(this.asyncExecutor)));
                }
                catch (Exception e) {
                    if (!(e instanceof FlowableException)) {
                        LOGGER.warn("Error while waiting for global acquire lock", (Throwable)e);
                    }
                }
            } else {
                timerJobs = (List)this.commandExecutor.execute((Command)new AcquireTimerJobsCmd(this.asyncExecutor));
            }
            if (!timerJobs.isEmpty()) {
                List finalTimerJobs = timerJobs;
                this.moveTimerJobsExecutorService.execute(() -> this.executeMoveTimerJobsToExecutableJobs(finalTimerJobs));
            }
            millisToWait = this.asyncExecutor.getDefaultTimerJobAcquireWaitTimeInMillis();
            int nrOfJobsAcquired = timerJobs.size();
            this.lifecycleListener.acquiredJobs(this.getEngineName(), nrOfJobsAcquired, this.asyncExecutor.getMaxTimerJobsPerAcquisition());
            if (nrOfJobsAcquired >= this.asyncExecutor.getMaxTimerJobsPerAcquisition()) {
                millisToWait = globalAcquireLockEnabled ? this.configuration.getLockPollRate().toMillis() : 0L;
            }
        }
        catch (FlowableOptimisticLockingException optimisticLockingException) {
            this.logOptimisticLockingException(optimisticLockingException);
        }
        catch (Throwable e) {
            LOGGER.warn("exception during timer job acquisition: {}", (Object)e.getMessage(), (Object)e);
            millisToWait = this.asyncExecutor.getDefaultTimerJobAcquireWaitTimeInMillis();
        }
        this.lifecycleListener.stopAcquiring(this.getEngineName());
        return millisToWait;
    }

    protected void executeMoveTimerJobsToExecutableJobs(List<TimerJobEntity> timerJobs) {
        try {
            if (this.configuration.isGlobalAcquireLockEnabled()) {
                this.commandExecutor.execute((Command)new BulkMoveTimerJobsToExecutableJobsCmd(this.jobManager, timerJobs));
            } else {
                this.commandExecutor.execute((Command)new MoveTimerJobsToExecutableJobsCmd(this.jobManager, timerJobs));
            }
        }
        catch (FlowableOptimisticLockingException optimisticLockingException) {
            this.logOptimisticLockingException(optimisticLockingException);
            this.unlockTimerJobs(timerJobs);
        }
        catch (Throwable t) {
            LOGGER.warn("exception during timer job move: {}", (Object)t.getMessage(), (Object)t);
            this.unlockTimerJobs(timerJobs);
        }
    }

    protected void logOptimisticLockingException(FlowableOptimisticLockingException optimisticLockingException) {
        if (this.configuration.isGlobalAcquireLockEnabled()) {
            LOGGER.warn("Optimistic locking exception (using global acquire lock)", (Throwable)optimisticLockingException);
        } else {
            LOGGER.debug("Optimistic locking exception during async job acquisition. If you have multiple async executors running against the same database, this exception means that this thread tried to acquire a due async job, which already was acquired by another async executor acquisition thread.This is expected behavior in a clustered environment. You can ignore this message if you indeed have multiple async executor acquisition threads running against the same database. For engine {}. Exception message: {}", (Object)this.getEngineName(), (Object)optimisticLockingException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sleep(long millisToWait) {
        if (millisToWait > 0L) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("timer job acquisition thread sleeping for {} millis", (Object)millisToWait);
                }
                Object object = this.MONITOR;
                synchronized (object) {
                    if (!this.isInterrupted) {
                        this.isWaiting.set(true);
                        this.lifecycleListener.startWaiting(this.getEngineName(), millisToWait);
                        this.MONITOR.wait(millisToWait);
                    }
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("timer job acquisition thread woke up");
                }
            }
            catch (InterruptedException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("timer job acquisition wait interrupted");
                }
            }
            finally {
                this.isWaiting.set(false);
            }
        }
    }

    protected String getEngineName() {
        return this.asyncExecutor.getJobServiceConfiguration().getEngineName();
    }

    protected void unlockTimerJobs(Collection<TimerJobEntity> timerJobs) {
        block3: {
            try {
                if (!timerJobs.isEmpty()) {
                    this.commandExecutor.execute((Command)new UnlockTimerJobsCmd(timerJobs, this.asyncExecutor.getJobServiceConfiguration()));
                }
            }
            catch (Throwable e) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug("Failed to unlock timer jobs during acquiring. This is OK since they will be unlocked when the reset expired jobs thread runs", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.MONITOR;
        synchronized (object) {
            this.isInterrupted = true;
            if (this.isWaiting.compareAndSet(true, false)) {
                this.MONITOR.notifyAll();
            }
        }
    }

    public void setConfiguration(AcquireJobsRunnableConfiguration configuration) {
        this.configuration = configuration;
    }
}

