/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.Job;
import org.flowable.job.api.JobNotFoundException;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.persistence.entity.SuspendedJobEntity;

public class MoveSuspendedJobToExecutableJobCmd
implements Command<Job>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String jobId;
    protected JobServiceConfiguration jobServiceConfiguration;

    public MoveSuspendedJobToExecutableJobCmd(String jobId, JobServiceConfiguration jobServiceConfiguration) {
        this.jobId = jobId;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public Job execute(CommandContext commandContext) {
        if (this.jobId == null) {
            throw new FlowableIllegalArgumentException("jobId and job is null");
        }
        SuspendedJobEntity job = (SuspendedJobEntity)this.jobServiceConfiguration.getSuspendedJobEntityManager().findById(this.jobId);
        if (job == null) {
            throw new JobNotFoundException(this.jobId);
        }
        return this.jobServiceConfiguration.getJobService().activateSuspendedJob(job);
    }

    public String getJobId() {
        return this.jobId;
    }
}

