/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.UserTask;
import org.flowable.editor.language.json.converter.BaseBpmnJsonConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverterContext;
import org.flowable.editor.language.json.converter.util.CollectionUtils;

public class UserTaskJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        UserTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        UserTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("UserTask", UserTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(UserTask.class, UserTaskJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "UserTask";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement, BpmnJsonConverterContext converterContext) {
        UserTask userTask = (UserTask)baseElement;
        String assignee = userTask.getAssignee();
        if (StringUtils.isNotEmpty((CharSequence)assignee) || CollectionUtils.isNotEmpty(userTask.getCandidateUsers()) || CollectionUtils.isNotEmpty(userTask.getCandidateGroups())) {
            ObjectNode assignmentNode = this.objectMapper.createObjectNode();
            ObjectNode assignmentValuesNode = this.objectMapper.createObjectNode();
            List idmAssigneeList = (List)userTask.getExtensionElements().get("activiti-idm-assignee");
            List idmAssigneeFieldList = (List)userTask.getExtensionElements().get("activiti-idm-assignee-field");
            if (CollectionUtils.isNotEmpty(idmAssigneeList) || CollectionUtils.isNotEmpty(idmAssigneeFieldList) || CollectionUtils.isNotEmpty((Collection)userTask.getExtensionElements().get("activiti-idm-candidate-user")) || CollectionUtils.isNotEmpty((Collection)userTask.getExtensionElements().get("activiti-idm-candidate-group"))) {
                assignmentValuesNode.put("type", "idm");
                ObjectNode idmNode = this.objectMapper.createObjectNode();
                assignmentValuesNode.set("idm", (JsonNode)idmNode);
                List canCompleteList = (List)userTask.getExtensionElements().get("initiator-can-complete");
                if (CollectionUtils.isNotEmpty(canCompleteList)) {
                    assignmentValuesNode.put("initiatorCanCompleteTask", Boolean.valueOf(((ExtensionElement)canCompleteList.get(0)).getElementText()));
                }
                if (StringUtils.isNotEmpty((CharSequence)userTask.getAssignee())) {
                    ObjectNode assigneeNode = this.objectMapper.createObjectNode();
                    assigneeNode.put("id", userTask.getAssignee());
                    idmNode.set("assignee", (JsonNode)assigneeNode);
                    idmNode.put("type", "user");
                    this.fillProperty("email", "assignee-info-email", assigneeNode, userTask);
                    this.fillProperty("firstName", "assignee-info-firstname", assigneeNode, userTask);
                    this.fillProperty("lastName", "assignee-info-lastname", assigneeNode, userTask);
                }
                List idmCandidateUserList = (List)userTask.getExtensionElements().get("activiti-idm-candidate-user");
                if (CollectionUtils.isNotEmpty(userTask.getCandidateUsers()) && CollectionUtils.isNotEmpty(idmCandidateUserList) && userTask.getCandidateUsers().size() > 0) {
                    ArrayNode candidateUsersNode = this.objectMapper.createArrayNode();
                    idmNode.set("candidateUsers", (JsonNode)candidateUsersNode);
                    idmNode.put("type", "users");
                    for (String candidateUser : userTask.getCandidateUsers()) {
                        ObjectNode candidateUserNode = this.objectMapper.createObjectNode();
                        candidateUserNode.put("id", candidateUser);
                        candidateUsersNode.add((JsonNode)candidateUserNode);
                        this.fillProperty("email", "user-info-email-" + candidateUser, candidateUserNode, userTask);
                        this.fillProperty("firstName", "user-info-firstname-" + candidateUser, candidateUserNode, userTask);
                        this.fillProperty("lastName", "user-info-lastname-" + candidateUser, candidateUserNode, userTask);
                    }
                }
                List idmCandidateGroupList = (List)userTask.getExtensionElements().get("activiti-idm-candidate-group");
                if (CollectionUtils.isNotEmpty(userTask.getCandidateGroups()) && CollectionUtils.isNotEmpty(idmCandidateGroupList) && userTask.getCandidateGroups().size() > 0) {
                    ArrayNode candidateGroupsNode = this.objectMapper.createArrayNode();
                    idmNode.set("candidateGroups", (JsonNode)candidateGroupsNode);
                    idmNode.put("type", "groups");
                    for (String candidateGroup : userTask.getCandidateGroups()) {
                        ObjectNode candidateGroupNode = this.objectMapper.createObjectNode();
                        candidateGroupNode.put("id", candidateGroup);
                        candidateGroupsNode.add((JsonNode)candidateGroupNode);
                        this.fillProperty("name", "group-info-name-" + candidateGroup, candidateGroupNode, userTask);
                    }
                }
            } else {
                ObjectNode candidateNode;
                ArrayNode candidateArrayNode;
                assignmentValuesNode.put("type", "static");
                if (StringUtils.isNotEmpty((CharSequence)assignee)) {
                    assignmentValuesNode.put("assignee", assignee);
                }
                if (CollectionUtils.isNotEmpty(userTask.getCandidateUsers())) {
                    candidateArrayNode = this.objectMapper.createArrayNode();
                    for (String candidateUser : userTask.getCandidateUsers()) {
                        candidateNode = this.objectMapper.createObjectNode();
                        candidateNode.put("value", candidateUser);
                        candidateArrayNode.add((JsonNode)candidateNode);
                    }
                    assignmentValuesNode.set("candidateUsers", (JsonNode)candidateArrayNode);
                }
                if (CollectionUtils.isNotEmpty(userTask.getCandidateGroups())) {
                    candidateArrayNode = this.objectMapper.createArrayNode();
                    for (String candidateGroup : userTask.getCandidateGroups()) {
                        candidateNode = this.objectMapper.createObjectNode();
                        candidateNode.put("value", candidateGroup);
                        candidateArrayNode.add((JsonNode)candidateNode);
                    }
                    assignmentValuesNode.set("candidateGroups", (JsonNode)candidateArrayNode);
                }
            }
            assignmentNode.set("assignment", (JsonNode)assignmentValuesNode);
            propertiesNode.set("usertaskassignment", (JsonNode)assignmentNode);
        }
        if (userTask.getPriority() != null) {
            this.setPropertyValue("prioritydefinition", userTask.getPriority(), propertiesNode);
        }
        this.setPropertyValue("skipexpression", userTask.getSkipExpression(), propertiesNode);
        if (StringUtils.isNotEmpty((CharSequence)userTask.getFormKey())) {
            Map<String, String> modelInfo = converterContext.getFormModelInfoForFormModelKey(userTask.getFormKey());
            if (modelInfo != null) {
                ObjectNode formRefNode = this.objectMapper.createObjectNode();
                formRefNode.put("id", modelInfo.get("id"));
                formRefNode.put("name", modelInfo.get("name"));
                formRefNode.put("key", modelInfo.get("key"));
                propertiesNode.set("formreference", (JsonNode)formRefNode);
            } else {
                this.setPropertyValue("formkeydefinition", userTask.getFormKey(), propertiesNode);
            }
        }
        this.setPropertyValue("formfieldvalidation", userTask.getValidateFormFields(), propertiesNode);
        this.setPropertyValue("duedatedefinition", userTask.getDueDate(), propertiesNode);
        this.setPropertyValue("calendarname", userTask.getBusinessCalendarName(), propertiesNode);
        this.setPropertyValue("categorydefinition", userTask.getCategory(), propertiesNode);
        this.setPropertyValue("taskidvariablename", userTask.getTaskIdVariableName(), propertiesNode);
        this.addFormProperties(userTask.getFormProperties(), propertiesNode);
    }

    protected int getExtensionElementValueAsInt(String name, UserTask userTask) {
        int intValue = 0;
        String value = this.getExtensionElementValue(name, userTask);
        if (NumberUtils.isCreatable((String)value)) {
            intValue = Integer.valueOf(value);
        }
        return intValue;
    }

    protected String getExtensionElementValue(String name, UserTask userTask) {
        String value = "";
        if (CollectionUtils.isNotEmpty((Collection)userTask.getExtensionElements().get(name))) {
            ExtensionElement extensionElement = (ExtensionElement)((List)userTask.getExtensionElements().get(name)).get(0);
            value = extensionElement.getElementText();
        }
        return value;
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BpmnJsonConverterContext converterContext) {
        JsonNode assignmentDefNode;
        UserTask task = new UserTask();
        task.setPriority(this.getPropertyValueAsString("prioritydefinition", elementNode));
        String formKey = this.getPropertyValueAsString("formkeydefinition", elementNode);
        if (StringUtils.isNotEmpty((CharSequence)formKey)) {
            task.setFormKey(formKey);
        } else {
            JsonNode formReferenceNode = this.getProperty("formreference", elementNode);
            if (formReferenceNode != null && formReferenceNode.get("id") != null) {
                String formModelId = formReferenceNode.get("id").asText();
                String formModelKey = converterContext.getFormModelKeyForFormModelId(formModelId);
                if (formModelKey != null) {
                    task.setFormKey(formModelKey);
                } else {
                    String key = formReferenceNode.get("key").asText();
                    if (StringUtils.isNotEmpty((CharSequence)key)) {
                        task.setFormKey(key);
                    }
                }
            }
        }
        task.setValidateFormFields(this.getPropertyValueAsString("formfieldvalidation", elementNode));
        task.setDueDate(this.getPropertyValueAsString("duedatedefinition", elementNode));
        task.setBusinessCalendarName(this.getPropertyValueAsString("calendarname", elementNode));
        task.setCategory(this.getPropertyValueAsString("categorydefinition", elementNode));
        task.setTaskIdVariableName(this.getPropertyValueAsString("taskidvariablename", elementNode));
        JsonNode assignmentNode = this.getProperty("usertaskassignment", elementNode);
        if (assignmentNode != null && (assignmentDefNode = assignmentNode.get("assignment")) != null) {
            JsonNode idmDefNode;
            JsonNode typeNode = assignmentDefNode.get("type");
            JsonNode canCompleteTaskNode = assignmentDefNode.get("initiatorCanCompleteTask");
            if (typeNode == null || "static".equalsIgnoreCase(typeNode.asText())) {
                JsonNode assigneeNode = assignmentDefNode.get("assignee");
                if (assigneeNode != null && !assigneeNode.isNull()) {
                    task.setAssignee(assigneeNode.asText());
                }
                task.setCandidateUsers(this.getValueAsList("candidateUsers", assignmentDefNode));
                task.setCandidateGroups(this.getValueAsList("candidateGroups", assignmentDefNode));
                if (StringUtils.isNotEmpty((CharSequence)task.getAssignee()) && !"$INITIATOR".equalsIgnoreCase(task.getAssignee())) {
                    if (canCompleteTaskNode != null && !canCompleteTaskNode.isNull()) {
                        this.addInitiatorCanCompleteExtensionElement(Boolean.valueOf(canCompleteTaskNode.asText()), task);
                    } else {
                        this.addInitiatorCanCompleteExtensionElement(false, task);
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)task.getAssignee()) && "$INITIATOR".equalsIgnoreCase(task.getAssignee())) {
                    this.addInitiatorCanCompleteExtensionElement(true, task);
                }
            } else if ("idm".equalsIgnoreCase(typeNode.asText()) && (idmDefNode = assignmentDefNode.get("idm")) != null && idmDefNode.has("type")) {
                JsonNode idmTypeNode = idmDefNode.get("type");
                if (idmTypeNode != null && "user".equalsIgnoreCase(idmTypeNode.asText()) && (idmDefNode.has("assignee") || idmDefNode.has("assigneeField"))) {
                    this.fillAssigneeInfo(idmDefNode, canCompleteTaskNode, task);
                } else if (idmTypeNode != null && "users".equalsIgnoreCase(idmTypeNode.asText()) && (idmDefNode.has("candidateUsers") || idmDefNode.has("candidateUserFields"))) {
                    this.fillCandidateUsers(idmDefNode, canCompleteTaskNode, task);
                } else if (idmTypeNode != null && "groups".equalsIgnoreCase(idmTypeNode.asText()) && (idmDefNode.has("candidateGroups") || idmDefNode.has("candidateGroupFields"))) {
                    this.fillCandidateGroups(idmDefNode, canCompleteTaskNode, task);
                } else {
                    task.setAssignee("$INITIATOR");
                    this.addExtensionElement("activiti-idm-initiator", String.valueOf(true), task);
                }
            }
        }
        task.setSkipExpression(this.getPropertyValueAsString("skipexpression", elementNode));
        this.convertJsonToFormProperties(elementNode, (BaseElement)task);
        return task;
    }

    protected void fillAssigneeInfo(JsonNode idmDefNode, JsonNode canCompleteTaskNode, UserTask task) {
        JsonNode assigneeNode = idmDefNode.get("assignee");
        if (assigneeNode != null && !assigneeNode.isNull()) {
            JsonNode idNode = assigneeNode.get("id");
            JsonNode emailNode = assigneeNode.get("email");
            if (idNode != null && !idNode.isNull() && StringUtils.isNotEmpty((CharSequence)idNode.asText())) {
                task.setAssignee(idNode.asText());
                this.addExtensionElement("activiti-idm-assignee", String.valueOf(true), task);
                this.addExtensionElement("assignee-info-email", emailNode, task);
                this.addExtensionElement("assignee-info-firstname", assigneeNode.get("firstName"), task);
                this.addExtensionElement("assignee-info-lastname", assigneeNode.get("lastName"), task);
            } else if (emailNode != null && !emailNode.isNull() && StringUtils.isNotEmpty((CharSequence)emailNode.asText())) {
                task.setAssignee(emailNode.asText());
            }
        }
        if (canCompleteTaskNode != null && !canCompleteTaskNode.isNull()) {
            this.addInitiatorCanCompleteExtensionElement(Boolean.valueOf(canCompleteTaskNode.asText()), task);
        } else {
            this.addInitiatorCanCompleteExtensionElement(false, task);
        }
    }

    protected void fillCandidateUsers(JsonNode idmDefNode, JsonNode canCompleteTaskNode, UserTask task) {
        JsonNode candidateUserFieldsNode;
        JsonNode idNode;
        ArrayList<String> candidateUsers = new ArrayList<String>();
        JsonNode candidateUsersNode = idmDefNode.get("candidateUsers");
        if (candidateUsersNode != null && candidateUsersNode.isArray()) {
            ArrayList<String> emails = new ArrayList<String>();
            for (JsonNode userNode : candidateUsersNode) {
                if (userNode == null || userNode.isNull()) continue;
                idNode = userNode.get("id");
                JsonNode emailNode = userNode.get("email");
                if (idNode != null && !idNode.isNull() && StringUtils.isNotEmpty((CharSequence)idNode.asText())) {
                    String id = idNode.asText();
                    candidateUsers.add(id);
                    this.addExtensionElement("user-info-email-" + id, emailNode, task);
                    this.addExtensionElement("user-info-firstname-" + id, userNode.get("firstName"), task);
                    this.addExtensionElement("user-info-lastname-" + id, userNode.get("lastName"), task);
                    continue;
                }
                if (emailNode == null || emailNode.isNull() || !StringUtils.isNotEmpty((CharSequence)emailNode.asText())) continue;
                String email = emailNode.asText();
                candidateUsers.add(email);
                emails.add(email);
            }
            if (emails.size() > 0) {
                this.addExtensionElement("activiti-candidate-users-emails", StringUtils.join(emails, (String)","), task);
            }
            if (candidateUsers.size() > 0) {
                this.addExtensionElement("activiti-idm-candidate-user", String.valueOf(true), task);
                if (canCompleteTaskNode != null && !canCompleteTaskNode.isNull()) {
                    this.addInitiatorCanCompleteExtensionElement(Boolean.valueOf(canCompleteTaskNode.asText()), task);
                } else {
                    this.addInitiatorCanCompleteExtensionElement(false, task);
                }
            }
        }
        if ((candidateUserFieldsNode = idmDefNode.get("candidateUserFields")) != null && candidateUserFieldsNode.isArray()) {
            for (JsonNode fieldNode : candidateUserFieldsNode) {
                idNode = fieldNode.get("id");
                if (idNode == null || idNode.isNull() || !StringUtils.isNotEmpty((CharSequence)idNode.asText())) continue;
                String id = idNode.asText();
                candidateUsers.add("field(" + id + ")");
                this.addExtensionElement("user-field-info-name-" + id, fieldNode.get("name"), task);
            }
        }
        if (candidateUsers.size() > 0) {
            task.setCandidateUsers(candidateUsers);
        }
    }

    protected void fillCandidateGroups(JsonNode idmDefNode, JsonNode canCompleteTaskNode, UserTask task) {
        JsonNode candidateGroupFieldsNode;
        String id;
        ArrayList<String> candidateGroups = new ArrayList<String>();
        JsonNode candidateGroupsNode = idmDefNode.get("candidateGroups");
        if (candidateGroupsNode != null && candidateGroupsNode.isArray()) {
            for (JsonNode groupNode : candidateGroupsNode) {
                if (groupNode == null || groupNode.isNull()) continue;
                JsonNode idNode = groupNode.get("id");
                JsonNode nameNode = groupNode.get("name");
                if (idNode == null || idNode.isNull() || !StringUtils.isNotEmpty((CharSequence)idNode.asText())) continue;
                id = idNode.asText();
                candidateGroups.add(id);
                this.addExtensionElement("group-info-name-" + id, nameNode, task);
            }
        }
        if ((candidateGroupFieldsNode = idmDefNode.get("candidateGroupFields")) != null && candidateGroupFieldsNode.isArray()) {
            for (JsonNode fieldNode : candidateGroupFieldsNode) {
                JsonNode idNode = fieldNode.get("id");
                if (idNode == null || idNode.isNull() || !StringUtils.isNotEmpty((CharSequence)idNode.asText())) continue;
                id = idNode.asText();
                candidateGroups.add("field(" + id + ")");
                this.addExtensionElement("group-field-info-name-" + id, fieldNode.get("name"), task);
            }
        }
        if (candidateGroups.size() > 0) {
            task.setCandidateGroups(candidateGroups);
            this.addExtensionElement("activiti-idm-candidate-group", String.valueOf(true), task);
            if (canCompleteTaskNode != null && !canCompleteTaskNode.isNull()) {
                this.addInitiatorCanCompleteExtensionElement(Boolean.valueOf(canCompleteTaskNode.asText()), task);
            } else {
                this.addInitiatorCanCompleteExtensionElement(false, task);
            }
        }
    }

    protected void addInitiatorCanCompleteExtensionElement(boolean canCompleteTask, UserTask task) {
        this.addExtensionElement("initiator-can-complete", String.valueOf(canCompleteTask), task);
    }

    protected void addExtensionElement(String name, JsonNode elementNode, UserTask task) {
        if (elementNode != null && !elementNode.isNull() && StringUtils.isNotEmpty((CharSequence)elementNode.asText())) {
            this.addExtensionElement(name, elementNode.asText(), task);
        }
    }

    protected void addExtensionElement(String name, String elementText, UserTask task) {
        ExtensionElement extensionElement = new ExtensionElement();
        extensionElement.setNamespace("http://flowable.org/modeler");
        extensionElement.setNamespacePrefix("modeler");
        extensionElement.setName(name);
        extensionElement.setElementText(elementText);
        task.addExtensionElement(extensionElement);
    }

    protected void fillProperty(String propertyName, String extensionElementName, ObjectNode elementNode, UserTask task) {
        List extensionElementList = (List)task.getExtensionElements().get(extensionElementName);
        if (CollectionUtils.isNotEmpty(extensionElementList)) {
            elementNode.put(propertyName, ((ExtensionElement)extensionElementList.get(0)).getElementText());
        }
    }
}

