/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.validation.validator.impl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ImplementationType;
import org.flowable.bpmn.model.Interface;
import org.flowable.bpmn.model.Operation;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.bpmn.model.TaskWithFieldExtensions;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.impl.ExternalInvocationTaskValidator;

public class ServiceTaskValidator
extends ExternalInvocationTaskValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List serviceTasks = process.findFlowElementsOfType(ServiceTask.class);
        for (ServiceTask serviceTask : serviceTasks) {
            this.verifyImplementation(process, serviceTask, errors);
            this.verifyType(process, serviceTask, errors);
            this.verifyResultVariableName(process, serviceTask, errors);
            this.verifyWebservice(bpmnModel, process, serviceTask, errors);
        }
    }

    protected void verifyImplementation(Process process, ServiceTask serviceTask, List<ValidationError> errors) {
        if (!(ImplementationType.IMPLEMENTATION_TYPE_CLASS.equalsIgnoreCase(serviceTask.getImplementationType()) || ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equalsIgnoreCase(serviceTask.getImplementationType()) || ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equalsIgnoreCase(serviceTask.getImplementationType()) || ImplementationType.IMPLEMENTATION_TYPE_WEBSERVICE.equalsIgnoreCase(serviceTask.getImplementationType()) || !StringUtils.isEmpty((CharSequence)serviceTask.getType()))) {
            this.addError(errors, "flowable-servicetask-missing-implementation", process, (BaseElement)serviceTask, "One of the attributes 'class', 'delegateExpression', 'type', 'operation', or 'expression' is mandatory on serviceTask.");
        }
    }

    protected void verifyType(Process process, ServiceTask serviceTask, List<ValidationError> errors) {
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getType())) {
            if (!(serviceTask.getType().equalsIgnoreCase("mail") || serviceTask.getType().equalsIgnoreCase("mule") || serviceTask.getType().equalsIgnoreCase("camel") || serviceTask.getType().equalsIgnoreCase("shell") || serviceTask.getType().equalsIgnoreCase("dmn") || serviceTask.getType().equalsIgnoreCase("http"))) {
                this.addError(errors, "flowable-servicetask-invalid-type", process, (BaseElement)serviceTask, "Invalid or unsupported service task type");
            }
            if (serviceTask.getType().equalsIgnoreCase("mail")) {
                this.validateFieldDeclarationsForEmail(process, (TaskWithFieldExtensions)serviceTask, serviceTask.getFieldExtensions(), errors);
            } else if (serviceTask.getType().equalsIgnoreCase("shell")) {
                this.validateFieldDeclarationsForShell(process, (TaskWithFieldExtensions)serviceTask, serviceTask.getFieldExtensions(), errors);
            } else if (serviceTask.getType().equalsIgnoreCase("dmn")) {
                this.validateFieldDeclarationsForDmn(process, (TaskWithFieldExtensions)serviceTask, serviceTask.getFieldExtensions(), errors);
            } else if (serviceTask.getType().equalsIgnoreCase("http")) {
                this.validateFieldDeclarationsForHttp(process, (TaskWithFieldExtensions)serviceTask, serviceTask.getFieldExtensions(), errors);
            }
        }
    }

    protected void verifyResultVariableName(Process process, ServiceTask serviceTask, List<ValidationError> errors) {
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getResultVariableName()) && (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(serviceTask.getImplementationType()) || ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(serviceTask.getImplementationType()))) {
            this.addError(errors, "flowable-servicetask-result-var-name-with-delegate", process, (BaseElement)serviceTask, "'resultVariableName' not supported for service tasks using 'class' or 'delegateExpression");
        }
    }

    protected void verifyWebservice(BpmnModel bpmnModel, Process process, ServiceTask serviceTask, List<ValidationError> errors) {
        if (ImplementationType.IMPLEMENTATION_TYPE_WEBSERVICE.equalsIgnoreCase(serviceTask.getImplementationType()) && StringUtils.isNotEmpty((CharSequence)serviceTask.getOperationRef())) {
            boolean operationFound = false;
            if (bpmnModel.getInterfaces() != null && !bpmnModel.getInterfaces().isEmpty()) {
                for (Interface bpmnInterface : bpmnModel.getInterfaces()) {
                    if (bpmnInterface.getOperations() == null || bpmnInterface.getOperations().isEmpty()) continue;
                    for (Operation operation : bpmnInterface.getOperations()) {
                        if (operation.getId() == null || !operation.getId().equals(serviceTask.getOperationRef())) continue;
                        operationFound = true;
                    }
                }
            }
            if (!operationFound) {
                this.addError(errors, "flowable-servicetask-webservice-invalid-operation-ref", process, (BaseElement)serviceTask, "Invalid operation reference");
            }
        }
    }
}

