/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.history;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.engine.HistoryService;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.history.HistoricTaskInstanceResponse;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"History Task"}, description="Manage History Task Instances", authorizations={@Authorization(value="basicAuth")})
public class HistoricTaskInstanceResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected HistoryService historyService;

    @ApiOperation(value="Get a single historic task instance", tags={"History Task"}, notes="")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates that the historic task instances could be found."), @ApiResponse(code=404, message="Indicates that the historic task instances could not be found.")})
    @GetMapping(value={"/history/historic-task-instances/{taskId}"}, produces={"application/json"})
    public HistoricTaskInstanceResponse getTaskInstance(@ApiParam(name="taskId") @PathVariable String taskId, HttpServletRequest request) {
        return this.restResponseFactory.createHistoricTaskInstanceResponse(this.getHistoricTaskInstanceFromRequest(taskId));
    }

    @ApiOperation(value="Delete a historic task instance", tags={"History Task"}, notes="")
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates that the historic task instance was deleted."), @ApiResponse(code=404, message="Indicates that the historic task instance could not be found.")})
    @DeleteMapping(value={"/history/historic-task-instances/{taskId}"})
    public void deleteTaskInstance(@ApiParam(name="taskId") @PathVariable String taskId, HttpServletResponse response) {
        this.historyService.deleteHistoricTaskInstance(taskId);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    protected HistoricTaskInstance getHistoricTaskInstanceFromRequest(String taskId) {
        HistoricTaskInstance taskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        if (taskInstance == null) {
            throw new FlowableObjectNotFoundException("Could not find a task instance with id '" + taskId + "'.", HistoricTaskInstance.class);
        }
        return taskInstance;
    }
}

